/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.crate.common.StringUtils;
import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexNameResolver {
    private IndexNameResolver() {
    }

    public static Supplier<String> create(RelationName relationName, @Nullable String partitionIdent, @Nullable List<Input<?>> partitionedByInputs) {
        if (partitionIdent == null && (partitionedByInputs == null || partitionedByInputs.isEmpty())) {
            return IndexNameResolver.forTable(relationName);
        }
        if (partitionIdent == null) {
            return IndexNameResolver.forPartition(relationName, partitionedByInputs);
        }
        return IndexNameResolver.forPartition(relationName, partitionIdent);
    }

    public static Supplier<String> forTable(RelationName relationName) {
        return relationName::indexNameOrAlias;
    }

    private static Supplier<String> forPartition(RelationName relationName, String partitionIdent) {
        return () -> IndexParts.toIndexName(relationName, partitionIdent);
    }

    private static Supplier<String> forPartition(final RelationName relationName, List<Input<?>> partitionedByInputs) {
        assert (partitionedByInputs.size() > 0) : "must have at least 1 partitionedByInput";
        LoadingCache cache = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(20L).build((CacheLoader)new CacheLoader<List<String>, String>(){

            public String load(@Nonnull List<String> key) {
                return IndexParts.toIndexName(relationName, PartitionName.encodeIdent(key));
            }
        });
        return () -> {
            List<String> partitions = Lists2.map(partitionedByInputs, input -> StringUtils.nullOrString(input.value()));
            return (String)cache.getUnchecked(partitions);
        };
    }
}

