/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.index.IndexNotFoundException;

public final class GroupRowsByShard<TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item>
implements BiConsumer<ShardedRequests<TReq, TItem>, Row> {
    private static final Logger LOGGER = LogManager.getLogger(GroupRowsByShard.class);
    private final RowShardResolver rowShardResolver;
    private final List<? extends CollectExpression<Row, ?>> expressions;
    private final List<? extends CollectExpression<Row, ?>> sourceInfoExpressions;
    private final Function<String, TItem> itemFactory;
    private final Supplier<String> indexNameResolver;
    private final ClusterService clusterService;
    private final boolean autoCreateIndices;
    private final BiConsumer<ShardedRequests, String> itemFailureRecorder;
    private final Predicate<ShardedRequests> hasSourceUriFailure;
    private final Input<String> sourceUriInput;
    private final Input<Long> lineNumberInput;
    private final ToLongFunction<Row> estimateRowSize;

    public GroupRowsByShard(ClusterService clusterService, RowShardResolver rowShardResolver, ToLongFunction<Row> estimateRowSize, Supplier<String> indexNameResolver, List<? extends CollectExpression<Row, ?>> expressions, Function<String, TItem> itemFactory, boolean autoCreateIndices, UpsertResultContext upsertContext) {
        this.estimateRowSize = estimateRowSize;
        assert (expressions instanceof RandomAccess) : "expressions should be a RandomAccess list for zero allocation iterations";
        this.clusterService = clusterService;
        this.rowShardResolver = rowShardResolver;
        this.indexNameResolver = indexNameResolver;
        this.expressions = expressions;
        this.sourceInfoExpressions = upsertContext.getSourceInfoExpressions();
        this.itemFactory = itemFactory;
        this.itemFailureRecorder = upsertContext.getItemFailureRecorder();
        this.hasSourceUriFailure = upsertContext.getHasSourceUriFailureChecker();
        this.sourceUriInput = upsertContext.getSourceUriInput();
        this.lineNumberInput = upsertContext.getLineNumberInput();
        this.autoCreateIndices = autoCreateIndices;
    }

    public GroupRowsByShard(ClusterService clusterService, RowShardResolver rowShardResolver, ToLongFunction<Row> estimateRowSize, Supplier<String> indexNameResolver, List<? extends CollectExpression<Row, ?>> expressions, Function<String, TItem> itemFactory, boolean autoCreateIndices) {
        this(clusterService, rowShardResolver, estimateRowSize, indexNameResolver, expressions, itemFactory, autoCreateIndices, UpsertResultContext.forRowCount());
    }

    @Override
    public void accept(ShardedRequests<TReq, TItem> shardedRequests, Row row) {
        int i;
        for (i = 0; i < this.sourceInfoExpressions.size(); ++i) {
            this.sourceInfoExpressions.get(i).setNextRow(row);
        }
        if (this.hasSourceUriFailure.test(shardedRequests)) {
            return;
        }
        try {
            this.rowShardResolver.setNextRow(row);
            for (i = 0; i < this.expressions.size(); ++i) {
                this.expressions.get(i).setNextRow(row);
            }
            String id = this.rowShardResolver.id();
            ShardRequest.Item item = (ShardRequest.Item)this.itemFactory.apply(id);
            String indexName = this.indexNameResolver.get();
            String routing = this.rowShardResolver.routing();
            String sourceUri = this.sourceUriInput.value();
            Long lineNumber = this.lineNumberInput.value();
            RowSourceInfo rowSourceInfo = RowSourceInfo.emptyMarkerOrNewInstance(sourceUri, lineNumber);
            ShardLocation shardLocation = this.getShardLocation(indexName, id, routing);
            long sizeEstimate = this.estimateRowSize.applyAsLong(row);
            if (shardLocation == null) {
                shardedRequests.add(item, sizeEstimate, indexName, routing, rowSourceInfo);
            } else {
                shardedRequests.add(item, sizeEstimate, shardLocation, rowSourceInfo);
            }
        }
        catch (CircuitBreakingException e) {
            throw e;
        }
        catch (Throwable t) {
            this.itemFailureRecorder.accept(shardedRequests, t.getMessage());
        }
    }

    @Nullable
    private ShardLocation getShardLocation(String indexName, String id, @Nullable String routing) {
        try {
            ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(this.clusterService.state(), indexName, id, routing);
            ShardRouting shardRouting = shardIterator.nextOrNull();
            String nodeId = shardRouting == null ? null : (!shardRouting.active() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId());
            if (nodeId == null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to get the node id for index {} and shard {}", (Object)indexName, (Object)id);
            }
            return new ShardLocation(shardIterator.shardId(), nodeId);
        }
        catch (IndexNotFoundException e) {
            if (!this.autoCreateIndices) {
                throw e;
            }
            return null;
        }
    }

    void reResolveShardLocations(ShardedRequests<TReq, TItem> requests) {
        Iterator entryIt = requests.itemsByMissingIndex.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry e = entryIt.next();
            List items = e.getValue();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                ShardedRequests.ItemAndRoutingAndSourceInfo itemAndRoutingAndSourceInfo = it.next();
                ShardLocation shardLocation = this.getShardLocation(e.getKey(), ((ShardRequest.Item)itemAndRoutingAndSourceInfo.item).id(), itemAndRoutingAndSourceInfo.routing);
                if (shardLocation == null) {
                    throw new IllegalStateException("shardLocation not resolvable after createIndices");
                }
                requests.add((ShardRequest.Item)itemAndRoutingAndSourceInfo.item, 0L, shardLocation, itemAndRoutingAndSourceInfo.rowSourceInfo);
                it.remove();
            }
            if (!items.isEmpty()) continue;
            entryIt.remove();
        }
    }
}

