/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.breaker.RamAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.expression.InputRow;
import io.crate.expression.symbol.Assignments;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;

public class ColumnIndexWriterProjector
implements Projector {
    private final ShardingUpsertExecutor shardingUpsertExecutor;

    public ColumnIndexWriterProjector(ClusterService clusterService, NodeJobsCounter nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, TransactionContext txnCtx, NodeContext nodeCtx, Settings settings, int targetTableNumShards, int targetTableNumReplicas, Supplier<String> indexNameResolver, TransportActionProvider transportActionProvider, List<ColumnIdent> primaryKeyIdents, List<? extends Symbol> primaryKeySymbols, @Nullable Symbol routingSymbol, ColumnIdent clusteredByColumn, List<Reference> columnReferences, List<Input<?>> insertInputs, List<? extends CollectExpression<Row, ?>> collectExpressions, boolean ignoreDuplicateKeys, @Nullable Map<Reference, Symbol> updateAssignments, int bulkActions, boolean autoCreateIndices, List<Symbol> returnValues, UUID jobId) {
        Symbol[] assignments;
        String[] updateColumnNames;
        RowShardResolver rowShardResolver = new RowShardResolver(txnCtx, nodeCtx, primaryKeyIdents, primaryKeySymbols, clusteredByColumn, routingSymbol);
        assert (columnReferences.size() == insertInputs.size()) : "number of insert inputs must be equal to the number of columns";
        if (updateAssignments == null) {
            updateColumnNames = null;
            assignments = null;
        } else {
            Assignments convert = Assignments.convert(updateAssignments, nodeCtx);
            updateColumnNames = convert.targetNames();
            assignments = convert.sources();
        }
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(settings), ignoreDuplicateKeys ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, updateColumnNames, columnReferences.toArray(new Reference[columnReferences.size()]), returnValues.isEmpty() ? null : returnValues.toArray(new Symbol[0]), jobId, true);
        InputRow insertValues = new InputRow(insertInputs);
        Function<String, ShardUpsertRequest.Item> itemFactory = id -> new ShardUpsertRequest.Item((String)id, assignments, insertValues.materialize(), null, null, null);
        UpsertResultContext upsertResultContext = returnValues.isEmpty() ? UpsertResultContext.forRowCount() : UpsertResultContext.forResultRows();
        this.shardingUpsertExecutor = new ShardingUpsertExecutor(clusterService, nodeJobsCounter, queryCircuitBreaker, ramAccounting, scheduler, executor, bulkActions, jobId, rowShardResolver, itemFactory, builder::newRequest, collectExpressions, indexNameResolver, autoCreateIndices, transportActionProvider.transportShardUpsertAction()::execute, transportActionProvider.transportBulkCreateIndicesAction(), targetTableNumShards, targetTableNumReplicas, upsertResultContext);
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, this.shardingUpsertExecutor, batchIterator.hasLazyResultSet());
    }

    @Override
    public boolean providesIndependentScroll() {
        return false;
    }
}

