/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.execution.engine.indexing.ShardedRequests;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BulkShardCreationLimiter
implements Predicate<ShardedRequests<?, ?>> {
    static final int MAX_NEW_SHARDS_PER_NODE = 10;
    private static final Logger LOGGER = LogManager.getLogger(BulkShardCreationLimiter.class);
    private final int numDataNodes;
    private final int numberOfAllShards;

    BulkShardCreationLimiter(int numberOfShards, int numberOfReplicas, int numDataNodes) {
        this.numDataNodes = numDataNodes;
        this.numberOfAllShards = numberOfShards + numberOfShards * numberOfReplicas;
    }

    @Override
    public boolean test(ShardedRequests<?, ?> requests) {
        int numberOfShardForAllIndices;
        int numberOfShardsPerNode;
        if (!requests.itemsByMissingIndex.isEmpty() && (numberOfShardsPerNode = (numberOfShardForAllIndices = this.numberOfAllShards * requests.itemsByMissingIndex.size()) / this.numDataNodes) >= 10) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Number of NEW shards per node {} reached maximum limit of {}", (Object)numberOfShardsPerNode, (Object)10);
            }
            return true;
        }
        return false;
    }
}

