/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.common.unit.TimeValue;
import io.crate.data.BatchIterator;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BackoffPolicy;

public class BatchIteratorBackpressureExecutor<T, R> {
    private static final Logger LOGGER = LogManager.getLogger(BatchIteratorBackpressureExecutor.class);
    private final UUID jobId;
    private final Executor executor;
    private final BatchIterator<T> batchIterator;
    private final Function<T, CompletableFuture<R>> execute;
    private final ScheduledExecutorService scheduler;
    private final Iterator<TimeValue> throttleDelay;
    private final BinaryOperator<R> combiner;
    private final Predicate<T> pauseConsumption;
    private final BiConsumer<R, Throwable> continueConsumptionOrFinish;
    private final AtomicInteger inFlightExecutions = new AtomicInteger(0);
    private final CompletableFuture<R> resultFuture = new CompletableFuture();
    private final Semaphore semaphore = new Semaphore(1);
    private final AtomicReference<R> resultRef;
    private final AtomicReference<Throwable> failureRef = new AtomicReference<Object>(null);
    private volatile boolean consumptionFinished = false;

    public BatchIteratorBackpressureExecutor(UUID jobId, ScheduledExecutorService scheduler, Executor executor, BatchIterator<T> batchIterator, Function<T, CompletableFuture<R>> execute, BinaryOperator<R> combiner, R identity, Predicate<T> pauseConsumption, BackoffPolicy backoffPolicy) {
        this.jobId = jobId;
        this.executor = executor;
        this.batchIterator = batchIterator;
        this.scheduler = scheduler;
        this.execute = execute;
        this.combiner = combiner;
        this.pauseConsumption = pauseConsumption;
        this.throttleDelay = backoffPolicy.iterator();
        this.resultRef = new AtomicReference<R>(identity);
        this.continueConsumptionOrFinish = this::continueConsumptionOrFinish;
    }

    public CompletableFuture<R> consumeIteratorAndExecute() {
        this.consumeIterator();
        return this.resultFuture;
    }

    private void continueConsumptionOrFinish(@Nullable R result, Throwable failure) {
        if (result != null) {
            this.resultRef.accumulateAndGet(result, this.combiner);
        }
        if (failure != null) {
            this.failureRef.set(failure);
        }
        int inFlight = this.inFlightExecutions.decrementAndGet();
        assert (inFlight >= 0) : "Number of in-flight executions must not be negative";
        if (this.consumptionFinished) {
            if (inFlight == 0) {
                this.setResult(this.resultRef.get(), failure == null ? this.failureRef.get() : failure);
            }
        } else {
            this.consumeIterator();
        }
    }

    private void setResult(R finalResult, Throwable failure) {
        this.batchIterator.close();
        if (failure == null) {
            this.resultFuture.complete(finalResult);
        } else {
            this.resultFuture.completeExceptionally(failure);
        }
    }

    private void consumeIterator() {
        if (!this.semaphore.tryAcquire()) {
            return;
        }
        try {
            while (this.batchIterator.moveNext()) {
                T item = this.batchIterator.currentElement();
                if (this.pauseConsumption.test(item)) {
                    long delayInMs = this.throttleDelay.next().getMillis();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Pausing consumption jobId={} delayInMs={}", (Object)this.jobId, (Object)delayInMs);
                    }
                    this.scheduler.schedule(this::resumeConsumption, delayInMs, TimeUnit.MILLISECONDS);
                    return;
                }
                this.execute(item);
            }
            this.inFlightExecutions.incrementAndGet();
            if (this.batchIterator.allLoaded()) {
                this.semaphore.release();
                this.consumptionFinished = true;
                this.continueConsumptionOrFinish.accept(null, null);
            } else {
                this.batchIterator.loadNextBatch().whenComplete((r, f) -> {
                    this.semaphore.release();
                    this.continueConsumptionOrFinish.accept((R)null, (Throwable)f);
                });
            }
        }
        catch (Throwable t) {
            this.batchIterator.close();
            this.resultFuture.completeExceptionally(t);
        }
    }

    private void execute(T item) {
        this.inFlightExecutions.incrementAndGet();
        this.execute.apply(item).whenComplete((BiConsumer)this.continueConsumptionOrFinish);
    }

    private void resumeConsumption() {
        T item = this.batchIterator.currentElement();
        if (this.pauseConsumption.test(item)) {
            this.scheduler.schedule(this::resumeConsumption, this.throttleDelay.next().getMillis(), TimeUnit.MILLISECONDS);
            return;
        }
        try {
            this.executor.execute(() -> this.doResumeConsumption(item));
        }
        catch (RejectedExecutionException e) {
            this.doResumeConsumption(item);
        }
    }

    private void doResumeConsumption(T item) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resuming consumption jobId={}", (Object)this.jobId);
        }
        this.execute(item);
        this.semaphore.release();
        this.consumeIterator();
    }
}

