/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntObjectMap;
import io.crate.Streamer;
import io.crate.action.FutureActionListener;
import io.crate.breaker.BlockBasedRamAccounting;
import io.crate.breaker.RamAccounting;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Bucket;
import io.crate.execution.engine.fetch.FetchOperation;
import io.crate.execution.engine.fetch.NodeFetchRequest;
import io.crate.execution.engine.fetch.NodeFetchResponse;
import io.crate.execution.engine.fetch.TransportFetchNodeAction;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TransportFetchOperation
implements FetchOperation {
    private static final Function<NodeFetchResponse, IntObjectMap<? extends Bucket>> GET_FETCHED = NodeFetchResponse::fetched;
    private final TransportFetchNodeAction transportFetchNodeAction;
    private final Map<String, ? extends IntObjectMap<Streamer[]>> nodeIdToReaderIdToStreamers;
    private final UUID jobId;
    private final int fetchPhaseId;
    private final RamAccounting ramAccounting;

    public TransportFetchOperation(TransportFetchNodeAction transportFetchNodeAction, Map<String, ? extends IntObjectMap<Streamer[]>> nodeIdToReaderIdToStreamers, UUID jobId, int fetchPhaseId, RamAccounting ramAccounting) {
        this.transportFetchNodeAction = transportFetchNodeAction;
        this.nodeIdToReaderIdToStreamers = nodeIdToReaderIdToStreamers;
        this.jobId = jobId;
        this.fetchPhaseId = fetchPhaseId;
        this.ramAccounting = ramAccounting;
    }

    @Override
    public CompletableFuture<IntObjectMap<? extends Bucket>> fetch(String nodeId, IntObjectMap<IntArrayList> toFetch, boolean closeContext) {
        FutureActionListener<NodeFetchResponse, IntObjectMap<? extends Bucket>> listener = new FutureActionListener<NodeFetchResponse, IntObjectMap<? extends Bucket>>(GET_FETCHED);
        this.transportFetchNodeAction.execute(nodeId, this.nodeIdToReaderIdToStreamers.get(nodeId), new NodeFetchRequest(this.jobId, this.fetchPhaseId, closeContext, toFetch), TransportFetchOperation.ramAccountingForIncomingResponse(this.ramAccounting, toFetch, closeContext), listener);
        return listener;
    }

    @VisibleForTesting
    static RamAccounting ramAccountingForIncomingResponse(RamAccounting ramAccounting, IntObjectMap<? extends IntContainer> toFetch, boolean closeContext) {
        if (toFetch.isEmpty() && closeContext) {
            return RamAccounting.NO_ACCOUNTING;
        }
        return new BlockBasedRamAccounting(usedBytes -> {
            RamAccounting ramAccounting2 = ramAccounting;
            synchronized (ramAccounting2) {
                ramAccounting.addBytes(usedBytes);
            }
        }, 0x200000);
    }
}

