/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntObjectMap;
import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.fetch.NodeFetchOperation;
import io.crate.execution.engine.fetch.NodeFetchRequest;
import io.crate.execution.engine.fetch.NodeFetchResponse;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportFetchNodeAction
implements NodeAction<NodeFetchRequest, NodeFetchResponse> {
    private static final String TRANSPORT_ACTION = "internal:crate:sql/node/fetch";
    private static final String EXECUTOR_NAME = "search";
    private final Transports transports;
    private final NodeFetchOperation nodeFetchOperation;

    @Inject
    public TransportFetchNodeAction(Settings settings, TransportService transportService, Transports transports, ThreadPool threadPool, JobsLogs jobsLogs, TasksService tasksService, CircuitBreakerService circuitBreakerService) {
        this.transports = transports;
        this.nodeFetchOperation = new NodeFetchOperation((ThreadPoolExecutor)threadPool.executor(EXECUTOR_NAME), EsExecutors.numberOfProcessors(settings), jobsLogs, tasksService, circuitBreakerService.getBreaker("query"));
        transportService.registerRequestHandler(TRANSPORT_ACTION, EXECUTOR_NAME, true, false, NodeFetchRequest::new, new NodeActionRequestHandler<NodeFetchRequest, NodeFetchResponse>(this));
    }

    public void execute(String targetNode, IntObjectMap<Streamer[]> streamers, NodeFetchRequest request, RamAccounting ramAccounting, ActionListener<NodeFetchResponse> listener) {
        this.transports.sendRequest(TRANSPORT_ACTION, targetNode, request, listener, new ActionListenerResponseHandler<NodeFetchResponse>(listener, in -> new NodeFetchResponse(in, streamers, ramAccounting)));
    }

    @Override
    public CompletableFuture<NodeFetchResponse> nodeOperation(NodeFetchRequest request) {
        CompletableFuture<? extends IntObjectMap<StreamBucket>> resultFuture = this.nodeFetchOperation.fetch(request.jobId(), request.fetchPhaseId(), request.toFetch(), request.isCloseContext());
        return resultFuture.thenApply(NodeFetchResponse::new);
    }
}

