/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.common.CheckedBiConsumer;

public class ReaderContext {
    private final LeafReaderContext leafReaderContext;
    private final CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> storedFieldsReader;

    public ReaderContext(LeafReaderContext leafReaderContext, CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> storedFieldsReader) {
        this.leafReaderContext = leafReaderContext;
        this.storedFieldsReader = storedFieldsReader;
    }

    public ReaderContext(LeafReaderContext leafReaderContext) {
        this(leafReaderContext, (arg_0, arg_1) -> ((LeafReader)leafReaderContext.reader()).document(arg_0, arg_1));
    }

    public void visitDocument(int docId, StoredFieldVisitor visitor) throws IOException {
        this.storedFieldsReader.accept(docId, visitor);
    }

    public LeafReader reader() {
        return this.leafReaderContext.reader();
    }

    public int docBase() {
        return this.leafReaderContext.docBase;
    }
}

