/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.data.Bucket;
import io.crate.data.Row;
import io.crate.execution.engine.fetch.FetchId;
import io.crate.execution.engine.fetch.FetchRows;
import io.crate.execution.engine.fetch.ReaderBucket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ReaderBuckets {
    private final IntObjectHashMap<ReaderBucket> readerBuckets = new IntObjectHashMap();
    private final ArrayList<Object[]> rows = new ArrayList();
    private final FetchRows fetchRows;

    public ReaderBuckets(FetchRows fetchRows) {
        this.fetchRows = fetchRows;
    }

    public void add(Row row) {
        Object[] cells = row.materialize();
        this.rows.add(cells);
        for (int i : this.fetchRows.fetchIdPositions()) {
            Object fetchId = cells[i];
            if (fetchId == null) continue;
            this.require((Long)fetchId);
        }
    }

    private void require(long fetchId) {
        int readerId = FetchId.decodeReaderId(fetchId);
        int docId = FetchId.decodeDocId(fetchId);
        ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(readerId);
        if (readerBucket == null) {
            readerBucket = new ReaderBucket();
            this.readerBuckets.put(readerId, (Object)readerBucket);
        }
        readerBucket.require(docId);
    }

    public Iterator<Row> getOutputRows(List<IntObjectMap<? extends Bucket>> resultsByReader) {
        for (IntObjectMap<? extends Bucket> result : resultsByReader) {
            if (result == null) continue;
            for (IntObjectCursor cursor : result) {
                ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(cursor.key);
                assert (readerBucket != null) : "If we get a result for a reader, there must be a readerBucket for it";
                readerBucket.fetched((Bucket)cursor.value);
            }
        }
        return new Iterator<Row>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ReaderBuckets.this.rows.size();
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Iterator is exhausted");
                }
                Object[] row = ReaderBuckets.this.rows.get(this.idx);
                ++this.idx;
                return ReaderBuckets.this.fetchRows.updatedOutputRow(row, arg_0 -> ReaderBuckets.this.readerBuckets.get(arg_0));
            }
        };
    }

    public IntObjectHashMap<IntArrayList> generateToFetch(IntSet readerIds) {
        IntObjectHashMap toFetch = new IntObjectHashMap(readerIds.size());
        for (IntCursor readerIdCursor : readerIds) {
            ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(readerIdCursor.value);
            if (readerBucket == null || readerBucket.isEmpty()) continue;
            toFetch.put(readerIdCursor.value, (Object)readerBucket.sortedDocs());
        }
        return toFetch;
    }
}

