/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.data.Bucket;
import io.crate.data.Row;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;

class ReaderBucket {
    private final IntObjectHashMap<Object[]> docs = new IntObjectHashMap();
    private IntArrayList sortedDocs;

    ReaderBucket() {
    }

    void require(int doc) {
        this.docs.putIfAbsent(doc, null);
    }

    Object[] get(int doc) {
        return (Object[])this.docs.get(doc);
    }

    IntArrayList sortedDocs() {
        if (this.sortedDocs == null) {
            int[] keys = this.docs.keys().toArray();
            Arrays.sort(keys);
            this.sortedDocs = new IntArrayList(keys.length);
            this.sortedDocs.add(keys);
        }
        return this.sortedDocs;
    }

    void fetched(Bucket bucket) {
        assert (bucket.size() == this.docs.size()) : String.format(Locale.ENGLISH, "requested %d docs but got %d", this.docs.size(), bucket.size());
        assert (this.sortedDocs != null) : "sortedDocs() must have been called before fetched()";
        Iterator rowIterator = bucket.iterator();
        for (IntCursor cursor : this.sortedDocs) {
            this.docs.put(cursor.value, (Object)((Row)rowIterator.next()).materialize());
        }
        this.sortedDocs = null;
        assert (!rowIterator.hasNext()) : "no more rows should exist";
    }

    public boolean isEmpty() {
        return this.docs.isEmpty();
    }
}

