/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.data.Bucket;
import io.crate.execution.engine.distribution.StreamBucket;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class NodeFetchResponse
extends TransportResponse {
    @Nullable
    private final IntObjectMap<StreamBucket> fetched;

    public NodeFetchResponse(@Nullable IntObjectMap<StreamBucket> fetched) {
        this.fetched = fetched;
    }

    @Nullable
    public IntObjectMap<? extends Bucket> fetched() {
        return this.fetched;
    }

    public NodeFetchResponse(StreamInput in, IntObjectMap<Streamer[]> streamers, RamAccounting ramAccounting) throws IOException {
        ramAccounting.addBytes(in.available());
        int numReaders = in.readVInt();
        if (numReaders > 0) {
            assert (streamers != null) : "streamers must not be null";
            this.fetched = new IntObjectHashMap(numReaders);
            for (int i = 0; i < numReaders; ++i) {
                int readerId = in.readVInt();
                StreamBucket bucket = new StreamBucket(in, Objects.requireNonNull((Streamer[])streamers.get(readerId), "streamers must exist for readerId=" + readerId));
                this.fetched.put(readerId, (Object)bucket);
            }
        } else {
            this.fetched = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.fetched == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fetched.size());
            for (IntObjectCursor cursor : this.fetched) {
                out.writeVInt(cursor.key);
                ((StreamBucket)cursor.value).writeTo(out);
            }
        }
    }
}

