/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class NodeFetchRequest
extends TransportRequest {
    private final UUID jobId;
    private final int fetchPhaseId;
    private final boolean closeContext;
    @Nullable
    private final IntObjectMap<IntArrayList> toFetch;

    public NodeFetchRequest(UUID jobId, int fetchPhaseId, boolean closeContext, IntObjectMap<IntArrayList> toFetch) {
        this.jobId = jobId;
        this.fetchPhaseId = fetchPhaseId;
        this.closeContext = closeContext;
        this.toFetch = toFetch.isEmpty() ? null : toFetch;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public int fetchPhaseId() {
        return this.fetchPhaseId;
    }

    public boolean isCloseContext() {
        return this.closeContext;
    }

    @Nullable
    public IntObjectMap<IntArrayList> toFetch() {
        return this.toFetch;
    }

    public NodeFetchRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
        this.fetchPhaseId = in.readVInt();
        this.closeContext = in.readBoolean();
        int numReaders = in.readVInt();
        if (numReaders > 0) {
            IntObjectHashMap toFetch = new IntObjectHashMap(numReaders);
            for (int i = 0; i < numReaders; ++i) {
                int readerId = in.readVInt();
                int numDocs = in.readVInt();
                IntArrayList docs = new IntArrayList(numDocs);
                toFetch.put(readerId, (Object)docs);
                for (int j = 0; j < numDocs; ++j) {
                    docs.add(in.readInt());
                }
            }
            this.toFetch = toFetch;
        } else {
            this.toFetch = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeVInt(this.fetchPhaseId);
        out.writeBoolean(this.closeContext);
        if (this.toFetch == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.toFetch.size());
            for (IntObjectCursor toFetchCursor : this.toFetch) {
                out.writeVInt(toFetchCursor.key);
                out.writeVInt(((IntContainer)toFetchCursor.value).size());
                for (IntCursor docCursor : (IntContainer)toFetchCursor.value) {
                    out.writeInt(docCursor.value);
                }
            }
        }
    }
}

