/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.Streamer;
import io.crate.breaker.BlockBasedRamAccounting;
import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.breaker.RamAccounting;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.fetch.FetchCollector;
import io.crate.execution.engine.fetch.FetchTask;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.support.ThreadPools;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperService;

public class NodeFetchOperation {
    private final ThreadPoolExecutor executor;
    private final int numProcessors;
    private final JobsLogs jobsLogs;
    private final TasksService tasksService;
    private final CircuitBreaker circuitBreaker;

    public NodeFetchOperation(ThreadPoolExecutor executor, int numProcessors, JobsLogs jobsLogs, TasksService tasksService, CircuitBreaker circuitBreaker) {
        this.executor = executor;
        this.numProcessors = numProcessors;
        this.jobsLogs = jobsLogs;
        this.tasksService = tasksService;
        this.circuitBreaker = circuitBreaker;
    }

    public CompletableFuture<? extends IntObjectMap<StreamBucket>> fetch(UUID jobId, int phaseId, @Nullable IntObjectMap<IntArrayList> docIdsToFetch, boolean closeTaskOnFinish) {
        if (docIdsToFetch == null) {
            if (closeTaskOnFinish) {
                this.tryCloseTask(jobId, phaseId);
            }
            this.jobsLogs.operationStarted(phaseId, jobId, "fetch", () -> -1L);
            this.jobsLogs.operationFinished(phaseId, jobId, null);
            return CompletableFuture.completedFuture(new IntObjectHashMap(0));
        }
        RootTask context = this.tasksService.getTask(jobId);
        FetchTask fetchTask = (FetchTask)context.getTask(phaseId);
        this.jobsLogs.operationStarted(phaseId, jobId, "fetch", () -> -1L);
        BiConsumer<IntObjectMap, Throwable> whenComplete = (res, err) -> {
            if (closeTaskOnFinish) {
                if (err == null) {
                    fetchTask.close();
                } else {
                    fetchTask.kill((Throwable)err);
                }
            }
            if (err == null) {
                this.jobsLogs.operationFinished(phaseId, jobId, null);
            } else {
                this.jobsLogs.operationFinished(phaseId, jobId, SQLExceptions.messageOf(err));
            }
        };
        try {
            return this.doFetch(fetchTask, docIdsToFetch).whenComplete(whenComplete);
        }
        catch (Throwable t) {
            whenComplete.accept(null, t);
            return CompletableFuture.failedFuture(t);
        }
    }

    private void tryCloseTask(UUID jobId, int phaseId) {
        FetchTask fetchTask;
        RootTask rootTask = this.tasksService.getTaskOrNull(jobId);
        if (rootTask != null && (fetchTask = (FetchTask)rootTask.getTaskOrNull(phaseId)) != null) {
            fetchTask.close();
        }
    }

    private static HashMap<RelationName, TableFetchInfo> getTableFetchInfos(FetchTask fetchTask) {
        HashMap<RelationName, TableFetchInfo> result = new HashMap<RelationName, TableFetchInfo>(fetchTask.toFetch().size());
        for (Map.Entry<RelationName, Collection<Reference>> entry : fetchTask.toFetch().entrySet()) {
            TableFetchInfo tableFetchInfo = new TableFetchInfo(entry.getValue(), fetchTask);
            result.put(entry.getKey(), tableFetchInfo);
        }
        return result;
    }

    private CompletableFuture<? extends IntObjectMap<StreamBucket>> doFetch(FetchTask fetchTask, IntObjectMap<IntArrayList> toFetch) throws Exception {
        HashMap<RelationName, TableFetchInfo> tableFetchInfos = NodeFetchOperation.getTableFetchInfos(fetchTask);
        ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker("fetch-" + fetchTask.id(), this.circuitBreaker);
        ArrayList collectors = new ArrayList(toFetch.size());
        for (IntObjectCursor toFetchCursor : toFetch) {
            int readerId = toFetchCursor.key;
            IntArrayList docIds = (IntArrayList)toFetchCursor.value;
            RelationName ident = fetchTask.tableIdent(readerId);
            TableFetchInfo tfi = tableFetchInfos.get(ident);
            assert (tfi != null) : "tfi must not be null";
            FetchCollector collector = tfi.createCollector(readerId, new BlockBasedRamAccounting(ramAccounting::addBytes, 0x200000));
            collectors.add(() -> collector.collect(docIds));
        }
        return ((CompletableFuture)ThreadPools.runWithAvailableThreads(this.executor, ThreadPools.numIdleThreads(this.executor, this.numProcessors), collectors).thenApply(buckets -> {
            Iterator toFetchIt = toFetch.iterator();
            assert (toFetch.size() == buckets.size()) : "Must have a bucket per reader and they must be in the same order";
            IntObjectHashMap bucketByReader = new IntObjectHashMap(toFetch.size());
            for (StreamBucket bucket : buckets) {
                assert (toFetchIt.hasNext()) : "toFetchIt must have an element if there is one in buckets";
                int readerId = ((IntObjectCursor)toFetchIt.next()).key;
                bucketByReader.put(readerId, (Object)bucket);
            }
            return bucketByReader;
        })).whenComplete((result, err) -> ramAccounting.close());
    }

    private static class TableFetchInfo {
        private final Streamer<?>[] streamers;
        private final Collection<Reference> refs;
        private final FetchTask fetchTask;

        TableFetchInfo(Collection<Reference> refs, FetchTask fetchTask) {
            this.refs = refs;
            this.fetchTask = fetchTask;
            this.streamers = Symbols.streamerArray(refs);
        }

        FetchCollector createCollector(int readerId, RamAccounting ramAccounting) {
            IndexService indexService = this.fetchTask.indexService(readerId);
            MapperService mapperService = indexService.mapperService();
            LuceneReferenceResolver resolver = new LuceneReferenceResolver(indexService.index().getName(), mapperService::fullName, this.fetchTask.table(readerId).partitionedByColumns());
            ArrayList exprs = new ArrayList(this.refs.size());
            for (Reference reference : this.refs) {
                exprs.add((LuceneCollectorExpression<?>)resolver.getImplementation(reference));
            }
            return new FetchCollector(exprs, this.streamers, this.fetchTask, ramAccounting, readerId);
        }
    }
}

