/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.common.collections.BorrowedItem;
import io.crate.common.collections.RefCountedItem;
import io.crate.exceptions.Exceptions;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.Task;
import io.crate.metadata.IndexParts;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.ShardId;

public class FetchTask
implements Task {
    private final IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> searchers = new IntObjectHashMap();
    private final IntObjectHashMap<SharedShardContext> shardContexts = new IntObjectHashMap();
    private final FetchPhase phase;
    private final String localNodeId;
    private final SharedShardContexts sharedShardContexts;
    private final TreeMap<Integer, RelationName> tableIdents = new TreeMap();
    private final Metadata metadata;
    private final Iterable<? extends Routing> routingIterable;
    private final Map<RelationName, Collection<Reference>> toFetch;
    private final UUID jobId;
    private final Function<RelationName, DocTableInfo> getTableInfo;
    private final CompletableFuture<Void> result = new CompletableFuture();
    @GuardedBy(value="jobId")
    private int borrowed = 0;
    @GuardedBy(value="jobId")
    private Throwable killed;

    public FetchTask(UUID jobId, FetchPhase phase, String localNodeId, SharedShardContexts sharedShardContexts, Metadata metadata, Function<RelationName, DocTableInfo> getTableInfo, Iterable<? extends Routing> routingIterable) {
        this.jobId = jobId;
        this.phase = phase;
        this.localNodeId = localNodeId;
        this.sharedShardContexts = sharedShardContexts;
        this.metadata = metadata;
        this.routingIterable = routingIterable;
        this.toFetch = new HashMap<RelationName, Collection<Reference>>(phase.tableIndices().size());
        this.getTableInfo = getTableInfo;
    }

    private void closeSearchers() {
        for (IntObjectCursor cursor : this.searchers) {
            ((RefCountedItem)cursor.value).close();
        }
        this.searchers.clear();
    }

    public Map<RelationName, Collection<Reference>> toFetch() {
        return this.toFetch;
    }

    @Override
    public String name() {
        return this.phase.name();
    }

    @Override
    public long bytesUsed() {
        return -1L;
    }

    @Nonnull
    public RelationName tableIdent(int readerId) {
        Map.Entry<Integer, RelationName> entry = this.tableIdents.floorEntry(readerId);
        if (entry == null) {
            throw new IllegalArgumentException("No table has been registered for readerId=" + readerId);
        }
        return entry.getValue();
    }

    @Nonnull
    public DocTableInfo table(int readerId) {
        RelationName relationName = this.tableIdent(readerId);
        DocTableInfo table = this.getTableInfo.apply(relationName);
        if (table == null) {
            throw new IllegalStateException("TableInfo missing for relation " + relationName);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public BorrowedItem<IndexSearcher> searcher(int readerId) {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            if (this.killed != null) {
                throw Exceptions.toRuntimeException(this.killed);
            }
            RefCountedItem searcher = (RefCountedItem)this.searchers.get(readerId);
            if (searcher == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Searcher for reader with id %d not found", readerId));
            }
            ++this.borrowed;
            return new BorrowedItem<IndexSearcher>((IndexSearcher)searcher.item(), () -> {
                UUID uUID = this.jobId;
                synchronized (uUID) {
                    --this.borrowed;
                    if (this.borrowed == 0 && this.killed != null) {
                        this.closeSearchers();
                        this.result.completeExceptionally(this.killed);
                    }
                }
            });
        }
    }

    @Nonnull
    public IndexService indexService(int readerId) {
        SharedShardContext sharedShardContext = (SharedShardContext)this.shardContexts.get(readerId);
        if (sharedShardContext == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Reader with id %d not found", readerId));
        }
        return sharedShardContext.indexService();
    }

    public String toString() {
        return "FetchTask{phase=" + this.phase.phaseId() + ", borrowed=" + this.borrowed + ", done=" + this.result.isDone() + ", killed=" + this.killed + ", searchers=" + this.searchers.keys() + "}";
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(Throwable throwable) {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            this.killed = throwable;
            if (this.borrowed == 0) {
                this.closeSearchers();
                this.result.completeExceptionally(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            assert (this.borrowed == 0) : "Close shouldn't be called while searchers are in use";
            this.closeSearchers();
            if (this.killed == null) {
                this.result.complete(null);
            } else {
                this.result.completeExceptionally(this.killed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            if (this.killed != null) {
                this.result.completeExceptionally(this.killed);
                return;
            }
            HashMap<String, RelationName> index2TableIdent = new HashMap<String, RelationName>();
            for (Map.Entry entry : this.phase.tableIndices().asMap().entrySet()) {
                for (String string : (Collection)entry.getValue()) {
                    index2TableIdent.put(string, (RelationName)entry.getKey());
                }
            }
            HashSet<RelationName> tablesWithFetchRefs = new HashSet<RelationName>();
            for (Reference reference : this.phase.fetchRefs()) {
                tablesWithFetchRefs.add(reference.ident().tableIdent());
            }
            String string = "fetch-task: " + this.jobId.toString() + "-" + this.phase.phaseId() + "-" + this.phase.name();
            for (Routing routing : this.routingIterable) {
                Map<String, Map<String, IntIndexedContainer>> locations = routing.locations();
                Map<String, IntIndexedContainer> indexShards = locations.get(this.localNodeId);
                for (Map.Entry<String, IntIndexedContainer> indexShardsEntry : indexShards.entrySet()) {
                    String indexName = indexShardsEntry.getKey();
                    Integer base = this.phase.bases().get(indexName);
                    if (base == null) continue;
                    IndexMetadata indexMetadata = this.metadata.index(indexName);
                    if (indexMetadata == null) {
                        if (IndexParts.isPartitioned(indexName)) continue;
                        throw new IndexNotFoundException(indexName);
                    }
                    Index index = indexMetadata.getIndex();
                    RelationName ident = (RelationName)index2TableIdent.get(indexName);
                    assert (ident != null) : "no relationName found for index " + indexName;
                    this.tableIdents.put(base, ident);
                    this.toFetch.put(ident, new ArrayList());
                    for (IntCursor shard : indexShardsEntry.getValue()) {
                        ShardId shardId = new ShardId(index, shard.value);
                        int readerId = base + shardId.id();
                        SharedShardContext shardContext = (SharedShardContext)this.shardContexts.get(readerId);
                        if (shardContext != null) continue;
                        try {
                            shardContext = this.sharedShardContexts.createContext(shardId, readerId);
                            this.shardContexts.put(readerId, (Object)shardContext);
                            if (!tablesWithFetchRefs.contains(ident)) continue;
                            this.searchers.put(readerId, shardContext.acquireSearcher(string));
                        }
                        catch (IndexNotFoundException e) {
                            if (IndexParts.isPartitioned(indexName)) continue;
                            throw e;
                        }
                    }
                }
            }
            for (Reference reference : this.phase.fetchRefs()) {
                Collection<Reference> references = this.toFetch.get(reference.ident().tableIdent());
                if (references == null) continue;
                references.add(reference);
            }
        }
        if (this.searchers.isEmpty() || this.phase.fetchRefs().isEmpty()) {
            this.close();
        }
    }

    @Override
    public int id() {
        return this.phase.phaseId();
    }

    public UUID jobId() {
        return this.jobId;
    }
}

