/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import io.crate.data.AsyncFlatMapBatchIterator;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.FetchProjection;
import io.crate.execution.engine.fetch.FetchMapper;
import io.crate.execution.engine.fetch.FetchOperation;
import io.crate.execution.engine.fetch.FetchRows;
import io.crate.execution.engine.fetch.ReaderBuckets;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;

public final class FetchProjector {
    public static Projector create(FetchProjection projection, TransactionContext txnCtx, NodeContext nodeCtx, FetchOperation fetchOperation) {
        FetchRows fetchRows = FetchRows.create(txnCtx, nodeCtx, projection.fetchSources(), projection.outputSymbols());
        return source -> {
            BatchIterator<ReaderBuckets> buckets = BatchIterators.partition(source, projection.getFetchSize(), () -> new ReaderBuckets(fetchRows), ReaderBuckets::add, x -> false);
            return new AsyncFlatMapBatchIterator<ReaderBuckets, Row>(buckets, new FetchMapper(fetchOperation, projection.nodeReaders()));
        };
    }
}

