/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import io.crate.concurrent.CompletableFutures;
import io.crate.data.AsyncFlatMapper;
import io.crate.data.Row;
import io.crate.execution.engine.fetch.FetchOperation;
import io.crate.execution.engine.fetch.ReaderBuckets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FetchMapper
implements AsyncFlatMapper<ReaderBuckets, Row> {
    private static final Logger LOGGER = LogManager.getLogger(FetchMapper.class);
    private final FetchOperation fetchOperation;
    private final Map<String, IntSet> readerIdsByNode;

    public FetchMapper(FetchOperation fetchOperation, Map<String, IntSet> readerIdsByNode) {
        this.fetchOperation = fetchOperation;
        this.readerIdsByNode = readerIdsByNode;
    }

    @Override
    public CompletableFuture<? extends Iterator<Row>> apply(ReaderBuckets readerBuckets, boolean isLastCall) {
        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
        Iterator<Map.Entry<String, IntSet>> it = this.readerIdsByNode.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, IntSet> entry = it.next();
            IntObjectHashMap<IntArrayList> toFetch = readerBuckets.generateToFetch(entry.getValue());
            if (toFetch.isEmpty() && !isLastCall) continue;
            String nodeId = entry.getKey();
            try {
                futures.add(this.fetchOperation.fetch(nodeId, (IntObjectMap<IntArrayList>)toFetch, isLastCall));
            }
            catch (Throwable t) {
                futures.add(CompletableFuture.failedFuture(t));
            }
            if (!isLastCall) continue;
            it.remove();
        }
        return CompletableFutures.allAsList(futures).thenApply(readerBuckets::getOutputRows);
    }

    @Override
    public void close() {
        for (String nodeId : this.readerIdsByNode.keySet()) {
            this.fetchOperation.fetch(nodeId, (IntObjectMap<IntArrayList>)new IntObjectHashMap(0), true).exceptionally(e -> {
                LOGGER.error("An error happened while sending close fetchRequest to node=" + nodeId, e);
                return null;
            });
        }
    }
}

