/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import io.crate.concurrent.CompletableFutures;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.export.Output;
import io.crate.external.S3ClientHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OutputS3
extends Output {
    private final Executor executor;
    private final URI uri;
    private final boolean compression;

    public OutputS3(Executor executor, URI uri, WriterProjection.CompressionType compressionType) {
        this.executor = executor;
        this.uri = uri;
        this.compression = compressionType != null;
    }

    @Override
    public OutputStream acquireOutputStream() throws IOException {
        OutputStream outputStream = new S3OutputStream(this.executor, this.uri, new S3ClientHelper());
        if (this.compression) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }

    private static class S3OutputStream
    extends OutputStream {
        private static final int PART_SIZE = 0x500000;
        private final AmazonS3 client;
        private final InitiateMultipartUploadResult multipartUpload;
        private final Executor executor;
        private final String bucketName;
        private final String key;
        private final List<CompletableFuture<PartETag>> pendingUploads = new ArrayList<CompletableFuture<PartETag>>();
        private ByteArrayOutputStream outputStream;
        long currentPartBytes = 0L;
        int partNumber = 1;

        private S3OutputStream(Executor executor, URI uri, S3ClientHelper s3ClientHelper) throws IOException {
            this.executor = executor;
            this.bucketName = uri.getHost();
            this.key = uri.getPath().substring(1);
            this.outputStream = new ByteArrayOutputStream();
            this.client = s3ClientHelper.client(uri);
            this.multipartUpload = this.client.initiateMultipartUpload(new InitiateMultipartUploadRequest(this.bucketName, this.key));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
            this.currentPartBytes += (long)b.length;
            this.doUploadIfNeeded();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
            this.currentPartBytes += (long)len;
            this.doUploadIfNeeded();
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
            ++this.currentPartBytes;
            this.doUploadIfNeeded();
        }

        private void doUploadIfNeeded() throws IOException {
            if (this.currentPartBytes >= 0x500000L) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
                int currentPart = this.partNumber++;
                long currentPartSize = this.currentPartBytes;
                this.outputStream.close();
                this.outputStream = new ByteArrayOutputStream();
                this.pendingUploads.add(CompletableFutures.supplyAsync(() -> {
                    UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withPartNumber(currentPart).withPartSize(currentPartSize).withUploadId(this.multipartUpload.getUploadId()).withInputStream((InputStream)inputStream);
                    return this.client.uploadPart(uploadPartRequest).getPartETag();
                }, this.executor));
                this.currentPartBytes = 0L;
            }
        }

        @Override
        public void close() throws IOException {
            List<PartETag> partETags;
            UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withPartNumber(this.partNumber).withPartSize((long)this.outputStream.size()).withUploadId(this.multipartUpload.getUploadId()).withInputStream((InputStream)new ByteArrayInputStream(this.outputStream.toByteArray()));
            UploadPartResult uploadPartResult = this.client.uploadPart(uploadPartRequest);
            try {
                partETags = CompletableFutures.allAsList(this.pendingUploads).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            partETags.add(uploadPartResult.getPartETag());
            this.client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, this.key, this.multipartUpload.getUploadId(), partETags));
            super.close();
        }
    }
}

