/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.export.Output;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public class OutputFile
extends Output {
    private final String path;
    private final boolean overwrite;
    private final boolean compression;

    public OutputFile(URI uri, @Nullable WriterProjection.CompressionType compressionType) {
        if (uri.getHost() != null) {
            throw new IllegalArgumentException("the URI host must be defined");
        }
        this.path = uri.getPath();
        this.compression = compressionType != null;
        this.overwrite = true;
    }

    @Override
    public OutputStream acquireOutputStream() throws IOException {
        File outFile = new File(this.path);
        if (outFile.exists()) {
            if (!this.overwrite) {
                throw new IOException("File exists: " + this.path);
            }
            if (outFile.isDirectory()) {
                throw new IOException("Output path is a directory: " + this.path);
            }
        }
        OutputStream os = new FileOutputStream(outFile);
        if (this.compression) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedOutputStream(os);
    }
}

