/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.export.FileWriterCountCollector;
import io.crate.metadata.ColumnIdent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class FileWriterProjector
implements Projector {
    private final String uri;
    private final Iterable<CollectExpression<Row, ?>> collectExpressions;
    private final List<Input<?>> inputs;
    private final Map<ColumnIdent, Object> overwrites;
    @Nullable
    private final List<String> outputNames;
    private final WriterProjection.OutputFormat outputFormat;
    private final WriterProjection.CompressionType compressionType;
    private final Executor executor;

    public FileWriterProjector(Executor executor, String uri, @Nullable WriterProjection.CompressionType compressionType, @Nullable List<Input<?>> inputs, Iterable<CollectExpression<Row, ?>> collectExpressions, Map<ColumnIdent, Object> overwrites, @Nullable List<String> outputNames, WriterProjection.OutputFormat outputFormat) {
        this.collectExpressions = collectExpressions;
        this.executor = executor;
        this.inputs = inputs;
        this.overwrites = overwrites;
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        this.compressionType = compressionType;
        this.uri = uri;
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, new FileWriterCountCollector(this.executor, this.uri, this.compressionType, this.inputs, this.collectExpressions, this.overwrites, this.outputNames, this.outputFormat));
    }

    @Override
    public boolean providesIndependentScroll() {
        return false;
    }
}

