/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import com.fasterxml.jackson.core.JsonGenerator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.exceptions.SQLParseException;
import io.crate.exceptions.UnhandledServerException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.export.Output;
import io.crate.execution.engine.export.OutputFile;
import io.crate.execution.engine.export.OutputS3;
import io.crate.metadata.ColumnIdent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;

public class FileWriterCountCollector
implements Collector<Row, long[], Iterable<Row>> {
    private static final byte NEW_LINE = 10;
    private final Iterable<CollectExpression<Row, ?>> collectExpressions;
    private final List<Input<?>> inputs;
    private final Map<String, Object> overwrites;
    @Nullable
    private final List<String> outputNames;
    private final WriterProjection.OutputFormat outputFormat;
    private Output output;
    private final RowWriter rowWriter;

    FileWriterCountCollector(Executor executor, String uri, @Nullable WriterProjection.CompressionType compressionType, @Nullable List<Input<?>> inputs, Iterable<CollectExpression<Row, ?>> collectExpressions, Map<ColumnIdent, Object> overwrites, @Nullable List<String> outputNames, WriterProjection.OutputFormat outputFormat) {
        URI uri1;
        this.collectExpressions = collectExpressions;
        this.inputs = inputs;
        this.overwrites = FileWriterCountCollector.toNestedStringObjectMap(overwrites);
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        try {
            uri1 = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new SQLParseException(String.format(Locale.ENGLISH, "Invalid uri '%s'", uri), e);
        }
        if (uri1.getScheme() == null || uri1.getScheme().equals("file")) {
            this.output = new OutputFile(uri1, compressionType);
        } else if (uri1.getScheme().equalsIgnoreCase("s3")) {
            this.output = new OutputS3(executor, uri1, compressionType);
        } else {
            throw new UnsupportedFeatureException(String.format(Locale.ENGLISH, "Unknown scheme '%s'", uri1.getScheme()));
        }
        this.rowWriter = this.initWriter();
    }

    @VisibleForTesting
    static Map<String, Object> toNestedStringObjectMap(Map<ColumnIdent, Object> columnIdentObjectMap) {
        HashMap<String, Object> nestedMap;
        Map<String, Object> parent = nestedMap = new HashMap<String, Object>();
        block0: for (Map.Entry<ColumnIdent, Object> entry : columnIdentObjectMap.entrySet()) {
            ColumnIdent key = entry.getKey();
            Object value = entry.getValue();
            if (key.path().isEmpty()) {
                nestedMap.put(key.name(), value);
                continue;
            }
            LinkedList<String> path = new LinkedList<String>(key.path());
            path.add(0, key.name());
            while (true) {
                String currentKey = path.pop();
                if (path.isEmpty()) {
                    parent.put(currentKey, value);
                    continue block0;
                }
                Object o = parent.get(currentKey);
                if (o == null) {
                    HashMap child = new HashMap();
                    parent.put(currentKey, child);
                    parent = child;
                    continue;
                }
                assert (o instanceof Map) : "o must be instance of Map";
                parent = (Map)o;
            }
        }
        return nestedMap;
    }

    private RowWriter initWriter() {
        try {
            if (!this.overwrites.isEmpty()) {
                return new DocWriter(this.output.acquireOutputStream(), this.collectExpressions, this.overwrites);
            }
            if (this.outputFormat.equals((Object)WriterProjection.OutputFormat.JSON_ARRAY)) {
                return new ColumnRowWriter(this.output.acquireOutputStream(), this.collectExpressions, this.inputs);
            }
            if (this.outputNames != null && this.outputFormat.equals((Object)WriterProjection.OutputFormat.JSON_OBJECT)) {
                return new ColumnRowObjectWriter(this.output.acquireOutputStream(), this.collectExpressions, this.inputs, this.outputNames);
            }
            return new RawRowWriter(this.output.acquireOutputStream());
        }
        catch (IOException e) {
            throw new UnhandledServerException(String.format(Locale.ENGLISH, "Failed to open output: '%s'", e.getMessage()), e);
        }
    }

    private void closeWriterAndOutput() {
        try {
            if (this.rowWriter != null) {
                this.rowWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Supplier<long[]> supplier() {
        return () -> new long[1];
    }

    @Override
    public BiConsumer<long[], Row> accumulator() {
        return this::onNextRow;
    }

    private void onNextRow(long[] container, Row row) {
        this.rowWriter.write(row);
        container[0] = container[0] + 1L;
    }

    @Override
    public BinaryOperator<long[]> combiner() {
        return (state1, state2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public Function<long[], Iterable<Row>> finisher() {
        return container -> {
            this.closeWriterAndOutput();
            return Collections.singletonList(new Row1(container[0]));
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @VisibleForTesting
    static XContentBuilder createJsonBuilder(OutputStream outputStream) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder(outputStream);
        builder.generator().configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
        return builder;
    }

    static interface RowWriter {
        public void write(Row var1);

        public void close() throws IOException;
    }

    static class DocWriter
    implements RowWriter {
        private final OutputStream outputStream;
        private final Iterable<CollectExpression<Row, ?>> collectExpressions;
        private final Map<String, Object> overwrites;
        private final XContentBuilder builder;

        public DocWriter(OutputStream outputStream, Iterable<CollectExpression<Row, ?>> collectExpressions, Map<String, Object> overwrites) throws IOException {
            this.outputStream = outputStream;
            this.collectExpressions = collectExpressions;
            this.overwrites = overwrites;
            this.builder = FileWriterCountCollector.createJsonBuilder(outputStream);
        }

        @Override
        public void write(Row row) {
            for (CollectExpression<Row, ?> collectExpression : this.collectExpressions) {
                collectExpression.setNextRow(row);
            }
            Map doc = (Map)row.get(0);
            XContentHelper.update(doc, this.overwrites, false);
            try {
                this.builder.map(doc);
                this.builder.flush();
                this.outputStream.write(10);
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }
    }

    static class ColumnRowWriter
    implements RowWriter {
        private final Iterable<CollectExpression<Row, ?>> collectExpressions;
        private final OutputStream outputStream;
        protected final List<Input<?>> inputs;
        protected final XContentBuilder builder;

        ColumnRowWriter(OutputStream outputStream, Iterable<CollectExpression<Row, ?>> collectExpressions, List<Input<?>> inputs) throws IOException {
            this.outputStream = outputStream;
            this.collectExpressions = collectExpressions;
            this.inputs = inputs;
            this.builder = FileWriterCountCollector.createJsonBuilder(outputStream);
        }

        @Override
        public void write(Row row) {
            for (CollectExpression<Row, ?> collectExpression : this.collectExpressions) {
                collectExpression.setNextRow(row);
            }
            try {
                this.processInputs();
                this.builder.flush();
                this.outputStream.write(10);
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.builder.close();
            this.outputStream.close();
        }

        protected void processInputs() throws IOException {
            this.builder.startArray();
            for (Input<?> input : this.inputs) {
                this.builder.value(input.value());
            }
            this.builder.endArray();
        }
    }

    static class ColumnRowObjectWriter
    extends ColumnRowWriter {
        private final List<String> outputNames;

        public ColumnRowObjectWriter(OutputStream outputStream, Iterable<CollectExpression<Row, ?>> collectExpressions, List<Input<?>> inputs, List<String> outputNames) throws IOException {
            super(outputStream, collectExpressions, inputs);
            this.outputNames = outputNames;
        }

        @Override
        protected void processInputs() throws IOException {
            try {
                this.builder.startObject();
                for (int i = 0; i < this.inputs.size(); ++i) {
                    this.builder.field(this.outputNames.get(i), ((Input)this.inputs.get(i)).value());
                }
                this.builder.endObject();
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }
    }

    static class RawRowWriter
    implements RowWriter {
        private final OutputStream outputStream;

        RawRowWriter(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(Row row) {
            String value = (String)row.get(0);
            try {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                this.outputStream.write(bytes);
                this.outputStream.write(10);
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }
    }
}

