/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import io.crate.execution.engine.distribution.merge.PlainSortedMergeIterator;
import io.crate.execution.engine.distribution.merge.RecordingSortedMergeIterator;
import io.crate.execution.engine.distribution.merge.SortedMergeIterator;
import java.util.Comparator;

public class SortedPagingIterator<TKey, TRow>
implements PagingIterator<TKey, TRow> {
    private final SortedMergeIterator<TKey, TRow> mergingIterator;
    private boolean ignoreLeastExhausted = false;

    public SortedPagingIterator(Comparator<TRow> comparator, boolean needsRepeat) {
        this.mergingIterator = needsRepeat ? new RecordingSortedMergeIterator(comparator) : new PlainSortedMergeIterator(comparator);
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> iterables) {
        this.mergingIterator.merge(iterables);
    }

    @Override
    public void finish() {
        this.ignoreLeastExhausted = true;
    }

    @Override
    public TKey exhaustedIterable() {
        return this.mergingIterator.exhaustedIterable();
    }

    @Override
    public Iterable<TRow> repeat() {
        return this.mergingIterator.repeat();
    }

    @Override
    public boolean hasNext() {
        return this.mergingIterator.hasNext() && (this.ignoreLeastExhausted || !this.mergingIterator.isLeastExhausted());
    }

    @Override
    public TRow next() {
        return (TRow)this.mergingIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported for " + SortedPagingIterator.class.getSimpleName());
    }
}

