/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import com.carrotsearch.hppc.IntArrayList;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.SortedMergeIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;

class RecordingSortedMergeIterator<TKey, TRow>
extends UnmodifiableIterator<TRow>
implements SortedMergeIterator<TKey, TRow> {
    private final Queue<Indexed<TKey, PeekingIterator<TRow>>> queue;
    private Indexed<TKey, PeekingIterator<TRow>> lastUsedIter = null;
    private boolean leastExhausted = false;
    private final IntArrayList sortRecording = new IntArrayList();
    private final List<Iterable<TRow>> storedIterables = new ArrayList<Iterable<TRow>>();
    private TKey exhausted;

    RecordingSortedMergeIterator(Comparator<? super TRow> itemComparator) {
        Comparator heapComparator = (o1, o2) -> itemComparator.compare((Object)((PeekingIterator)o1.val).peek(), (Object)((PeekingIterator)o2.val).peek());
        this.queue = new PriorityQueue<Indexed<TKey, PeekingIterator<TRow>>>(2, heapComparator);
    }

    @Override
    public boolean hasNext() {
        this.reAddLastIterator();
        return !this.queue.isEmpty();
    }

    private void reAddLastIterator() {
        if (this.lastUsedIter != null) {
            if (((PeekingIterator)this.lastUsedIter.val).hasNext()) {
                this.queue.add(this.lastUsedIter);
            } else {
                this.leastExhausted = true;
                this.exhausted = this.lastUsedIter.key;
            }
            this.lastUsedIter = null;
        }
    }

    @Override
    public TRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more rows should exist");
        }
        this.lastUsedIter = this.queue.remove();
        this.sortRecording.add(this.lastUsedIter.i);
        return (TRow)((PeekingIterator)this.lastUsedIter.val).next();
    }

    private void addIterators(Iterable<? extends KeyIterable<TKey, TRow>> iterables) {
        for (KeyIterable<TKey, TRow> rowIterable : iterables) {
            Iterator<TRow> rowIterator = rowIterable.iterator();
            if (!rowIterator.hasNext()) continue;
            this.queue.add(new Indexed<TKey, PeekingIterator>(this.storedIterables.size(), rowIterable.key(), Iterators.peekingIterator(rowIterator)));
            this.storedIterables.add(rowIterable);
        }
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> numberedIterables) {
        if (this.lastUsedIter != null && ((PeekingIterator)this.lastUsedIter.val).hasNext()) {
            this.queue.add(this.lastUsedIter);
            this.lastUsedIter = null;
        }
        this.addIterators(numberedIterables);
        this.leastExhausted = false;
    }

    @Override
    public boolean isLeastExhausted() {
        return this.leastExhausted;
    }

    @Override
    public TKey exhaustedIterable() {
        return this.exhausted;
    }

    @Override
    public Iterable<TRow> repeat() {
        return () -> new ReplayingIterator(this.sortRecording.buffer, Iterables.transform(this.storedIterables, Iterable::iterator));
    }

    static class Indexed<TKey, TVal> {
        private final int i;
        private final TVal val;
        private final TKey key;

        Indexed(int i, TKey key, TVal val) {
            this.i = i;
            this.key = key;
            this.val = val;
        }
    }

    static class ReplayingIterator<T>
    extends AbstractIterator<T> {
        private final int[] sorting;
        private int index = 0;
        private final List<Iterator<T>> iters;
        private final int itersSize;

        ReplayingIterator(int[] sorting, Iterable<? extends Iterator<T>> iterators) {
            this.sorting = sorting;
            this.iters = ImmutableList.builder().addAll(iterators).build();
            this.itersSize = this.iters.size();
        }

        protected T computeNext() {
            if (this.index >= this.sorting.length) {
                return (T)this.endOfData();
            }
            int iterIdx = this.sorting[this.index++];
            assert (iterIdx < this.itersSize) : "invalid iters index";
            Iterator<T> iter = this.iters.get(iterIdx);
            if (!iter.hasNext()) {
                return (T)this.endOfData();
            }
            return iter.next();
        }
    }
}

