/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.breaker.RowAccounting;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;

public class RamAccountingPageIterator<TKey>
implements PagingIterator<TKey, Row> {
    @VisibleForTesting
    final PagingIterator<TKey, Row> delegatePagingIterator;
    private final RowAccounting<Row> rowAccounting;

    public RamAccountingPageIterator(PagingIterator<TKey, Row> delegatePagingIterator, RowAccounting<Row> rowAccounting) {
        this.delegatePagingIterator = delegatePagingIterator;
        this.rowAccounting = rowAccounting;
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, Row>> keyIterables) {
        for (KeyIterable<TKey, Row> iterable : keyIterables) {
            for (Row row : iterable) {
                this.rowAccounting.accountForAndMaybeBreak(row);
            }
        }
        this.delegatePagingIterator.merge(keyIterables);
    }

    @Override
    public void finish() {
        this.delegatePagingIterator.finish();
    }

    @Override
    public TKey exhaustedIterable() {
        return this.delegatePagingIterator.exhaustedIterable();
    }

    @Override
    public Iterable<Row> repeat() {
        return this.delegatePagingIterator.repeat();
    }

    @Override
    public boolean hasNext() {
        return this.delegatePagingIterator.hasNext();
    }

    @Override
    public Row next() {
        return (Row)this.delegatePagingIterator.next();
    }
}

