/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.SortedMergeIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;

class PlainSortedMergeIterator<TKey, TRow>
extends UnmodifiableIterator<TRow>
implements SortedMergeIterator<TKey, TRow> {
    private final Queue<NumberedPeekingIterator<TKey, TRow>> queue;
    private NumberedPeekingIterator<TKey, TRow> lastUsedIter = null;
    private boolean leastExhausted = false;
    private TKey exhausted;

    PlainSortedMergeIterator(Comparator<? super TRow> itemComparator) {
        Comparator heapComparator = (o1, o2) -> itemComparator.compare((Object)o1.peek(), (Object)o2.peek());
        this.queue = new PriorityQueue<NumberedPeekingIterator<TKey, TRow>>(2, heapComparator);
    }

    private void addIterators(Iterable<? extends KeyIterable<TKey, TRow>> iterables) {
        for (KeyIterable<TKey, TRow> iterable : iterables) {
            Iterator<TRow> rowIterator = iterable.iterator();
            if (!rowIterator.hasNext()) continue;
            this.queue.add(new NumberedPeekingIterator(iterable.key(), Iterators.peekingIterator(rowIterator)));
        }
    }

    @Override
    public boolean hasNext() {
        this.reAddLastIterator();
        return !this.queue.isEmpty();
    }

    private void reAddLastIterator() {
        if (this.lastUsedIter != null) {
            if (this.lastUsedIter.hasNext()) {
                this.queue.add(this.lastUsedIter);
            } else {
                this.leastExhausted = true;
                this.exhausted = this.lastUsedIter.key;
            }
            this.lastUsedIter = null;
        }
    }

    @Override
    public TRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more rows should exist");
        }
        this.lastUsedIter = this.queue.remove();
        return this.lastUsedIter.next();
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> numberedIterables) {
        if (this.lastUsedIter != null && this.lastUsedIter.hasNext()) {
            this.queue.add(this.lastUsedIter);
            this.lastUsedIter = null;
        }
        this.addIterators(numberedIterables);
        this.leastExhausted = false;
    }

    @Override
    public boolean isLeastExhausted() {
        return this.leastExhausted;
    }

    @Override
    public TKey exhaustedIterable() {
        return this.exhausted;
    }

    @Override
    public Iterable<TRow> repeat() {
        throw new UnsupportedOperationException("cannot repeat with " + this.getClass().getSimpleName());
    }

    private static class NumberedPeekingIterator<TKey, TRow>
    implements PeekingIterator<TRow> {
        private final TKey key;
        private final PeekingIterator<TRow> peekingIterator;

        NumberedPeekingIterator(TKey key, PeekingIterator<TRow> peekingIterator) {
            this.key = key;
            this.peekingIterator = peekingIterator;
        }

        public TRow peek() {
            return (TRow)this.peekingIterator.peek();
        }

        public TRow next() {
            return (TRow)this.peekingIterator.next();
        }

        public void remove() {
            this.peekingIterator.remove();
        }

        public boolean hasNext() {
            return this.peekingIterator.hasNext();
        }
    }
}

