/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import java.util.Collections;
import java.util.Iterator;

public class PassThroughPagingIterator<TKey, TRow>
extends ForwardingIterator<TRow>
implements PagingIterator<TKey, TRow> {
    private Iterator<TRow> iterator = Collections.emptyIterator();
    private final ImmutableList.Builder<KeyIterable<TKey, TRow>> iterables = ImmutableList.builder();
    private final boolean repeatable;
    private Iterable<TRow> storedForRepeat = null;

    private PassThroughPagingIterator(boolean repeatable) {
        this.repeatable = repeatable;
    }

    public static <TKey, TRow> PassThroughPagingIterator<TKey, TRow> repeatable() {
        return new PassThroughPagingIterator<TKey, TRow>(true);
    }

    public static <TKey, TRow> PassThroughPagingIterator<TKey, TRow> oneShot() {
        return new PassThroughPagingIterator<TKey, TRow>(false);
    }

    protected Iterator<TRow> delegate() {
        return this.iterator;
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> iterables) {
        Iterable concat = Iterables.concat(iterables);
        if (this.repeatable) {
            this.iterables.addAll(iterables);
            this.storedForRepeat = null;
        }
        this.iterator = this.iterator.hasNext() ? Iterators.concat(this.iterator, concat.iterator()) : concat.iterator();
    }

    @Override
    public void finish() {
    }

    @Override
    public TKey exhaustedIterable() {
        return null;
    }

    @Override
    public Iterable<TRow> repeat() {
        Iterable repeatMe = this.storedForRepeat;
        if (repeatMe == null) {
            this.storedForRepeat = repeatMe = Iterables.concat((Iterable)this.iterables.build());
        }
        return repeatMe;
    }
}

