/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.auth.user.User;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.TaskMissing;
import io.crate.execution.engine.distribution.DistributedResultRequest;
import io.crate.execution.engine.distribution.DistributedResultResponse;
import io.crate.execution.jobs.DownstreamRXTask;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.PageResultListener;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsRequest;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDistributedResultAction
implements NodeAction<DistributedResultRequest, DistributedResultResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportDistributedResultAction.class);
    private static final String DISTRIBUTED_RESULT_ACTION = "internal:crate:sql/node/merge";
    private final Transports transports;
    private final TasksService tasksService;
    private final ScheduledExecutorService scheduler;
    private final ClusterService clusterService;
    private final TransportKillJobsNodeAction killJobsAction;
    private final BackoffPolicy backoffPolicy;

    @Inject
    public TransportDistributedResultAction(Transports transports, TasksService tasksService, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportKillJobsNodeAction killJobsAction, Settings settings) {
        this(transports, tasksService, threadPool, transportService, clusterService, killJobsAction, BackoffPolicy.exponentialBackoff());
    }

    @VisibleForTesting
    TransportDistributedResultAction(Transports transports, TasksService tasksService, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportKillJobsNodeAction killJobsAction, BackoffPolicy backoffPolicy) {
        this.transports = transports;
        this.tasksService = tasksService;
        this.scheduler = threadPool.scheduler();
        this.clusterService = clusterService;
        this.killJobsAction = killJobsAction;
        this.backoffPolicy = backoffPolicy;
        transportService.registerRequestHandler(DISTRIBUTED_RESULT_ACTION, "same", DistributedResultRequest::new, new NodeActionRequestHandler<DistributedResultRequest, DistributedResultResponse>(this));
    }

    void pushResult(String node, DistributedResultRequest request, ActionListener<DistributedResultResponse> listener) {
        this.transports.sendRequest(DISTRIBUTED_RESULT_ACTION, node, request, listener, new ActionListenerResponseHandler<DistributedResultResponse>(listener, DistributedResultResponse::new));
    }

    @Override
    public CompletableFuture<DistributedResultResponse> nodeOperation(DistributedResultRequest request) {
        return this.nodeOperation(request, null);
    }

    private CompletableFuture<DistributedResultResponse> nodeOperation(DistributedResultRequest request, @Nullable Iterator<TimeValue> retryDelay) {
        DownstreamRXTask rxTask;
        RootTask rootTask = this.tasksService.getTaskOrNull(request.jobId());
        if (rootTask == null) {
            if (this.tasksService.recentlyFailed(request.jobId())) {
                return CompletableFuture.failedFuture(JobKilledException.of("Received result for job=" + request.jobId() + " but there is no context for this job due to a failure during the setup."));
            }
            return this.retryOrFailureResponse(request, retryDelay);
        }
        try {
            rxTask = (DownstreamRXTask)rootTask.getTask(request.executionPhaseId());
        }
        catch (ClassCastException e) {
            return CompletableFuture.failedFuture(new IllegalStateException(String.format(Locale.ENGLISH, "Found execution rootTask for %d but it's not a downstream rootTask", request.executionPhaseId()), e));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        PageBucketReceiver pageBucketReceiver = rxTask.getBucketReceiver(request.executionPhaseInputId());
        if (pageBucketReceiver == null) {
            return CompletableFuture.failedFuture(new IllegalStateException(String.format(Locale.ENGLISH, "Couldn't find BucketReceiver for input %d", request.executionPhaseInputId())));
        }
        Throwable throwable = request.throwable();
        if (throwable == null) {
            SendResponsePageResultListener pageResultListener = new SendResponsePageResultListener();
            pageBucketReceiver.setBucket(request.bucketIdx(), request.readRows(pageBucketReceiver.streamers()), request.isLast(), pageResultListener);
            return pageResultListener.future;
        }
        pageBucketReceiver.kill(throwable);
        return CompletableFuture.completedFuture(new DistributedResultResponse(false));
    }

    private CompletableFuture<DistributedResultResponse> retryOrFailureResponse(final DistributedResultRequest request, @Nullable Iterator<TimeValue> retryDelay) {
        if (retryDelay == null) {
            retryDelay = this.backoffPolicy.iterator();
        }
        if (retryDelay.hasNext()) {
            TimeValue delay = retryDelay.next();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("scheduling retry to start node operation for jobId: {} in {}ms", (Object)request.jobId(), (Object)delay.getMillis());
            }
            NodeOperationRunnable operationRunnable = new NodeOperationRunnable(request, retryDelay);
            this.scheduler.schedule(operationRunnable::run, delay.getMillis(), TimeUnit.MILLISECONDS);
            return operationRunnable;
        }
        List<String> excludedNodeIds = Collections.singletonList(this.clusterService.localNode().getId());
        KillJobsRequest killRequest = new KillJobsRequest(List.of(request.jobId()), User.CRATE_USER.name(), "Received data for job=" + request.jobId() + " but there is no job context present. This can happen due to bad network latency or if individual nodes are unresponsive due to high load");
        this.killJobsAction.broadcast(killRequest, (ActionListener)new ActionListener<Long>(){

            @Override
            public void onResponse(Long numKilled) {
            }

            @Override
            public void onFailure(Exception e) {
                LOGGER.debug("Could not kill " + request.jobId(), (Throwable)e);
            }
        }, excludedNodeIds);
        return CompletableFuture.failedFuture(new TaskMissing(TaskMissing.Type.ROOT, request.jobId()));
    }

    private static class SendResponsePageResultListener
    implements PageResultListener {
        private final CompletableFuture<DistributedResultResponse> future = new CompletableFuture();

        private SendResponsePageResultListener() {
        }

        @Override
        public void needMore(boolean needMore) {
            LOGGER.trace("sending needMore response, need more? {}", (Object)needMore);
            this.future.complete(new DistributedResultResponse(needMore));
        }
    }

    private class NodeOperationRunnable
    extends CompletableFuture<DistributedResultResponse> {
        private final DistributedResultRequest request;
        private final Iterator<TimeValue> retryDelay;

        NodeOperationRunnable(DistributedResultRequest request, Iterator<TimeValue> retryDelay) {
            this.request = request;
            this.retryDelay = retryDelay;
        }

        public CompletableFuture<DistributedResultResponse> run() {
            return TransportDistributedResultAction.this.nodeOperation(this.request, this.retryDelay).whenComplete((r, f) -> {
                if (f == null) {
                    this.complete(r);
                } else {
                    this.completeExceptionally((Throwable)f);
                }
            });
        }
    }
}

