/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.concurrent.CompletionListenable;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.distribution.StreamBucketCollector;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class SingleBucketBuilder
implements RowConsumer,
CompletionListenable<StreamBucket> {
    private final Streamer<?>[] streamers;
    private RamAccounting ramAccounting;
    private final CompletableFuture<StreamBucket> bucketFuture = new CompletableFuture();

    public SingleBucketBuilder(Streamer<?>[] streamers, RamAccounting ramAccounting) {
        this.streamers = streamers;
        this.ramAccounting = ramAccounting;
    }

    @Override
    public CompletableFuture<StreamBucket> completionFuture() {
        return this.bucketFuture;
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.bucketFuture.whenComplete((ignored, t) -> iterator.close());
            StreamBucketCollector streamBucketCollector = new StreamBucketCollector(this.streamers, this.ramAccounting);
            BatchIterators.collect(iterator, streamBucketCollector.supplier().get(), streamBucketCollector, this.bucketFuture);
        } else {
            if (iterator != null) {
                iterator.close();
            }
            this.bucketFuture.completeExceptionally(failure);
        }
    }
}

