/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.BatchIterator;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.distribution.DistributedResultRequest;
import io.crate.execution.engine.distribution.DistributedResultResponse;
import io.crate.execution.engine.distribution.MultiBucketBuilder;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.distribution.TransportDistributedResultAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public class DistributingConsumer
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(DistributingConsumer.class);
    private final Executor responseExecutor;
    private final UUID jobId;
    private final int targetPhaseId;
    private final byte inputId;
    private final int bucketIdx;
    private final TransportDistributedResultAction distributedResultAction;
    private final int pageSize;
    private final StreamBucket[] buckets;
    private final List<Downstream> downstreams;
    private final boolean traceEnabled = LOGGER.isTraceEnabled();
    private final CompletableFuture<Void> completionFuture;
    @VisibleForTesting
    final MultiBucketBuilder multiBucketBuilder;
    private volatile Throwable failure;

    public DistributingConsumer(Executor responseExecutor, UUID jobId, MultiBucketBuilder multiBucketBuilder, int targetPhaseId, byte inputId, int bucketIdx, Collection<String> downstreamNodeIds, TransportDistributedResultAction distributedResultAction, int pageSize) {
        this.responseExecutor = responseExecutor;
        this.jobId = jobId;
        this.multiBucketBuilder = multiBucketBuilder;
        this.targetPhaseId = targetPhaseId;
        this.inputId = inputId;
        this.bucketIdx = bucketIdx;
        this.distributedResultAction = distributedResultAction;
        this.pageSize = pageSize;
        this.buckets = new StreamBucket[downstreamNodeIds.size()];
        this.completionFuture = new CompletableFuture();
        this.downstreams = new ArrayList<Downstream>(downstreamNodeIds.size());
        for (String downstreamNodeId : downstreamNodeIds) {
            this.downstreams.add(new Downstream(downstreamNodeId));
        }
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.consumeIt(iterator);
        } else {
            this.completionFuture.completeExceptionally(failure);
            this.forwardFailure(null, failure);
        }
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void consumeIt(BatchIterator<Row> it) {
        try {
            while (it.moveNext()) {
                this.multiBucketBuilder.add(it.currentElement());
                if (this.multiBucketBuilder.size() < this.pageSize && this.multiBucketBuilder.ramBytesUsed() < Paging.MAX_PAGE_BYTES) continue;
                this.forwardResults(it, false);
                return;
            }
            if (it.allLoaded()) {
                this.forwardResults(it, true);
            } else {
                it.loadNextBatch().whenComplete((r, t) -> {
                    if (t == null) {
                        this.consumeIt(it);
                    } else {
                        this.forwardFailure(it, (Throwable)t);
                    }
                });
            }
        }
        catch (Throwable t2) {
            this.forwardFailure(it, t2);
        }
    }

    private void forwardFailure(final @Nullable BatchIterator it, Throwable f) {
        Throwable failure = SQLExceptions.unwrap(f);
        final AtomicInteger numActiveRequests = new AtomicInteger(this.downstreams.size());
        DistributedResultRequest request = new DistributedResultRequest(this.jobId, this.targetPhaseId, this.inputId, this.bucketIdx, failure, false);
        for (int i = 0; i < this.downstreams.size(); ++i) {
            final Downstream downstream = this.downstreams.get(i);
            if (!downstream.needsMoreData) {
                this.countdownAndMaybeCloseIt(numActiveRequests, it);
                continue;
            }
            if (this.traceEnabled) {
                LOGGER.trace("forwardFailure targetNode={} jobId={} targetPhase={}/{} bucket={} failure={}", (Object)downstream.nodeId, (Object)this.jobId, (Object)this.targetPhaseId, (Object)this.inputId, (Object)this.bucketIdx, (Object)failure);
            }
            this.distributedResultAction.pushResult(downstream.nodeId, request, new ActionListener<DistributedResultResponse>(){

                @Override
                public void onResponse(DistributedResultResponse response) {
                    downstream.needsMoreData = false;
                    DistributingConsumer.this.countdownAndMaybeCloseIt(numActiveRequests, it);
                }

                @Override
                public void onFailure(Exception e) {
                    if (DistributingConsumer.this.traceEnabled) {
                        LOGGER.trace("Error sending failure to downstream={} jobId={} targetPhase={}/{} bucket={} failure={}", (Object)downstream.nodeId, (Object)DistributingConsumer.this.jobId, (Object)DistributingConsumer.this.targetPhaseId, (Object)DistributingConsumer.this.inputId, (Object)DistributingConsumer.this.bucketIdx, (Object)e);
                    }
                    DistributingConsumer.this.countdownAndMaybeCloseIt(numActiveRequests, it);
                }
            });
        }
    }

    private void countdownAndMaybeCloseIt(AtomicInteger numActiveRequests, @Nullable BatchIterator it) {
        if (numActiveRequests.decrementAndGet() == 0 && it != null) {
            it.close();
            this.completionFuture.complete(null);
        }
    }

    private void forwardResults(final BatchIterator<Row> it, boolean isLast) {
        this.multiBucketBuilder.build(this.buckets);
        final AtomicInteger numActiveRequests = new AtomicInteger(this.downstreams.size());
        for (int i = 0; i < this.downstreams.size(); ++i) {
            final Downstream downstream = this.downstreams.get(i);
            if (!downstream.needsMoreData) {
                this.countdownAndMaybeContinue(it, numActiveRequests, true);
                continue;
            }
            if (this.traceEnabled) {
                LOGGER.trace("forwardResults targetNode={} jobId={} targetPhase={}/{} bucket={} isLast={}", (Object)downstream.nodeId, (Object)this.jobId, (Object)this.targetPhaseId, (Object)this.inputId, (Object)this.bucketIdx, (Object)isLast);
            }
            this.distributedResultAction.pushResult(downstream.nodeId, new DistributedResultRequest(this.jobId, this.targetPhaseId, this.inputId, this.bucketIdx, this.buckets[i], isLast), new ActionListener<DistributedResultResponse>(){

                @Override
                public void onResponse(DistributedResultResponse response) {
                    downstream.needsMoreData = response.needMore();
                    DistributingConsumer.this.countdownAndMaybeContinue(it, numActiveRequests, false);
                }

                @Override
                public void onFailure(Exception e) {
                    DistributingConsumer.this.failure = e;
                    downstream.needsMoreData = false;
                    DistributingConsumer.this.countdownAndMaybeContinue(it, numActiveRequests, false);
                }
            });
        }
    }

    private void countdownAndMaybeContinue(BatchIterator<Row> it, AtomicInteger numActiveRequests, boolean sameExecutor) {
        if (numActiveRequests.decrementAndGet() == 0) {
            if (this.downstreams.stream().anyMatch(Downstream::needsMoreData)) {
                if (this.failure == null) {
                    if (sameExecutor) {
                        this.consumeIt(it);
                    } else {
                        try {
                            this.responseExecutor.execute(() -> this.consumeIt(it));
                        }
                        catch (EsRejectedExecutionException e) {
                            this.failure = e;
                            this.forwardFailure(it, this.failure);
                        }
                    }
                } else {
                    this.forwardFailure(it, this.failure);
                }
            } else {
                it.close();
                this.completionFuture.complete(null);
            }
        }
    }

    public String toString() {
        return "DistributingConsumer{jobId=" + this.jobId + ", targetPhaseId=" + this.targetPhaseId + ", inputId=" + this.inputId + ", bucketIdx=" + this.bucketIdx + ", downstreams=" + this.downstreams + "}";
    }

    private static class Downstream {
        private final String nodeId;
        private boolean needsMoreData = true;

        Downstream(String nodeId) {
            this.nodeId = nodeId;
        }

        boolean needsMoreData() {
            return this.needsMoreData;
        }

        public String toString() {
            return "Downstream{" + this.nodeId + "', needsMoreData=" + this.needsMoreData + "}";
        }
    }
}

