/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.common.unit.TimeValue;
import io.crate.execution.engine.collect.stats.NodeStatsRequest;
import io.crate.execution.engine.collect.stats.NodeStatsResponse;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import io.crate.expression.reference.sys.node.NodeStatsContext;
import io.crate.expression.reference.sys.node.NodeStatsContextFieldResolver;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportNodeStatsAction
implements NodeAction<NodeStatsRequest, NodeStatsResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/sys/nodes";
    private static final String EXECUTOR = "management";
    private final NodeStatsContextFieldResolver nodeContextFieldsResolver;
    private final Transports transports;

    @Inject
    public TransportNodeStatsAction(TransportService transportService, NodeStatsContextFieldResolver nodeContextFieldsResolver, Transports transports) {
        this.nodeContextFieldsResolver = nodeContextFieldsResolver;
        this.transports = transports;
        transportService.registerRequestHandler(ACTION_NAME, EXECUTOR, NodeStatsRequest::new, new NodeActionRequestHandler<NodeStatsRequest, NodeStatsResponse>(this));
    }

    public void execute(String nodeName, NodeStatsRequest request, ActionListener<NodeStatsResponse> listener, TimeValue timeout) {
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(timeout).build();
        this.transports.sendRequest(ACTION_NAME, nodeName, request, listener, new ActionListenerResponseHandler<NodeStatsResponse>(listener, NodeStatsResponse::new), options);
    }

    @Override
    public CompletableFuture<NodeStatsResponse> nodeOperation(NodeStatsRequest request) {
        try {
            NodeStatsContext context = this.nodeContextFieldsResolver.forTopColumnIdents(request.columnIdents());
            return CompletableFuture.completedFuture(new NodeStatsResponse(context));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

