/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.unit.TimeValue;
import io.crate.expression.reference.sys.job.ContextLog;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class TimeBasedQEviction {
    private TimeBasedQEviction() {
    }

    static ScheduledFuture<?> scheduleTruncate(long delayInMs, long intervalInMs, Queue<? extends ContextLog> q, ScheduledExecutorService scheduler, TimeValue expiration) {
        return scheduler.scheduleWithFixedDelay(() -> TimeBasedQEviction.removeExpiredLogs(q, System.currentTimeMillis(), expiration.getMillis()), delayInMs, intervalInMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    static <T extends ContextLog> void removeExpiredLogs(Queue<T> q, long currentTimeMillis, long expirationTime) {
        ContextLog t;
        long expired = currentTimeMillis - expirationTime;
        Iterator iterator = q.iterator();
        while (iterator.hasNext() && (t = (ContextLog)iterator.next()).ended() < expired) {
            q.remove();
        }
    }
}

