/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import com.google.common.collect.ForwardingQueue;
import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.CircuitBreaker;

public class RamAccountingQueue<T>
extends ForwardingQueue<T> {
    private static final Logger LOGGER = LogManager.getLogger(RamAccountingQueue.class);
    private final Queue<T> delegate;
    private final RamAccounting ramAccounting;
    private final SizeEstimator<T> sizeEstimator;
    private final CircuitBreaker breaker;
    private final AtomicBoolean exceeded;

    public RamAccountingQueue(Queue<T> delegate, CircuitBreaker breaker, SizeEstimator<T> sizeEstimator) {
        this.delegate = delegate;
        this.breaker = breaker;
        this.sizeEstimator = sizeEstimator;
        this.ramAccounting = new ConcurrentRamAccounting(breaker::addWithoutBreaking, bytes -> breaker.addWithoutBreaking(-bytes));
        this.exceeded = new AtomicBoolean(false);
    }

    private static String contextId() {
        return String.format(Locale.ENGLISH, "RamAccountingQueue[%s]", UUID.randomUUID().toString());
    }

    public boolean offer(T o) {
        this.ramAccounting.addBytes(this.sizeEstimator.estimateSize(o));
        if (this.exceededBreaker() && this.exceeded.compareAndSet(false, true)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Memory limit for breaker [{}] was exceeded. Queue [{}] is cleared.", (Object)this.breaker.getName(), (Object)RamAccountingQueue.contextId());
            }
            this.release();
            this.ramAccounting.addBytes(this.sizeEstimator.estimateSize(o));
            this.exceeded.set(false);
        }
        return this.delegate.offer(o);
    }

    protected Queue<T> delegate() {
        return this.delegate;
    }

    public void release() {
        this.delegate.clear();
        this.ramAccounting.release();
    }

    public boolean exceededBreaker() {
        return this.breaker.getUsed() >= this.breaker.getLimit();
    }
}

