/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.metadata.ColumnIdent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class NodeStatsRequest
extends TransportRequest {
    private final Set<ColumnIdent> columns;

    public NodeStatsRequest(Set<ColumnIdent> columns) {
        this.columns = columns;
    }

    public Set<ColumnIdent> columnIdents() {
        return this.columns;
    }

    public NodeStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.columns = new HashSet<ColumnIdent>();
        int columnIdentsSize = in.readVInt();
        for (int i = 0; i < columnIdentsSize; ++i) {
            this.columns.add(new ColumnIdent(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.columns.size());
        for (ColumnIdent columnIdent : this.columns) {
            columnIdent.writeTo(out);
        }
    }
}

