/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.execution.engine.collect.stats.LogSink;
import io.crate.expression.ExpressionsInput;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class FilteredLogSink<T>
implements LogSink<T> {
    private static final Logger STATEMENT_LOGGER = LogManager.getLogger((String)"StatementLog");
    private final ExpressionsInput<T, Boolean> memoryFilter;
    private final ExpressionsInput<T, Boolean> persistFilter;
    private final Function<T, Message> createLogMessage;
    final LogSink<T> delegate;

    FilteredLogSink(ExpressionsInput<T, Boolean> memoryFilter, ExpressionsInput<T, Boolean> persistFilter, Function<T, Message> createLogMessage, LogSink<T> delegate) {
        this.memoryFilter = memoryFilter;
        this.persistFilter = persistFilter;
        this.createLogMessage = createLogMessage;
        this.delegate = delegate;
    }

    @Override
    public void add(T item) {
        Boolean recordToPersistentLog;
        Boolean recordToMemory = this.memoryFilter.value(item);
        if (recordToMemory != null && recordToMemory.booleanValue()) {
            this.delegate.add(item);
        }
        if ((recordToPersistentLog = this.persistFilter.value(item)) != null && recordToPersistentLog.booleanValue() && STATEMENT_LOGGER.isInfoEnabled()) {
            STATEMENT_LOGGER.info(this.createLogMessage.apply(item));
        }
    }

    @Override
    public void addAll(Iterable<T> iterable) {
        iterable.forEach(this::add);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }
}

