/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.TableFunctionCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.InputCollectExpression;
import io.crate.execution.engine.collect.ValueAndInputRow;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.expression.InputCondition;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.RowType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.StreamSupport;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class TableFunctionCollectSource
implements CollectSource {
    private final NodeContext nodeCtx;
    private final InputFactory inputFactory;

    @Inject
    public TableFunctionCollectSource(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
        this.inputFactory = new InputFactory(nodeCtx);
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
        TableFunctionCollectPhase phase = (TableFunctionCollectPhase)collectPhase;
        TableFunctionImplementation<?> functionImplementation = phase.functionImplementation();
        RowType rowType = functionImplementation.returnType();
        List<Literal<?>> inputs = phase.functionArguments();
        ArrayList topLevelInputs = new ArrayList(phase.toCollect().size());
        List<String> columns = rowType.fieldNames();
        InputFactory.Context<InputCollectExpression> ctx = this.inputFactory.ctxForRefs(txnCtx, ref -> {
            for (int i = 0; i < columns.size(); ++i) {
                String column = (String)columns.get(i);
                if (!ref.column().isTopLevel() || !ref.column().name().equals(column)) continue;
                return new InputCollectExpression(i);
            }
            throw new IllegalStateException("Column `" + ref + "` not found in " + functionImplementation.signature().getName().displayName());
        });
        for (Symbol symbol : phase.toCollect()) {
            topLevelInputs.add(ctx.add(symbol));
        }
        ValueAndInputRow inputRow = new ValueAndInputRow(topLevelInputs, ctx.expressions());
        Input<?> condition = ctx.add(phase.where());
        Iterable rows = () -> StreamSupport.stream(((Iterable)functionImplementation.evaluate(txnCtx, this.nodeCtx, inputs.toArray(new Input[0]))).spliterator(), false).map(inputRow).filter(InputCondition.asPredicate(condition)).iterator();
        return CompletableFuture.completedFuture(InMemoryBatchIterator.of(rows, SentinelRow.SENTINEL, functionImplementation.hasLazyResultSet()));
    }
}

