/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.expression.reference.StaticTableDefinition;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.metadata.sys.SysTableDefinitions;
import io.crate.metadata.table.TableInfo;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class SysTableRegistry {
    private final SysSchemaInfo sysSchemaInfo;
    private final SysTableDefinitions tableDefinitions;

    @Inject
    public SysTableRegistry(SysSchemaInfo sysSchemaInfo, SysTableDefinitions tableDefinitions) {
        this.sysSchemaInfo = sysSchemaInfo;
        this.tableDefinitions = tableDefinitions;
    }

    public <R> void registerSysTable(TableInfo tableInfo, Supplier<CompletableFuture<? extends Iterable<R>>> iterableSupplier, Map<ColumnIdent, ? extends RowCollectExpressionFactory<R>> expressionFactories, boolean involvesIO) {
        RelationName ident = tableInfo.ident();
        this.sysSchemaInfo.registerSysTable(tableInfo);
        this.tableDefinitions.registerTableDefinition(ident, new StaticTableDefinition(iterableSupplier, expressionFactories, involvesIO));
    }
}

