/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.engine.collect.BlobShardCollectorProvider;
import io.crate.execution.engine.collect.LuceneShardCollectorProvider;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

public class ShardCollectorProviderFactory {
    private final Schemas schemas;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final TransportActionProvider transportActionProvider;
    private final BlobIndicesService blobIndicesService;
    private final NodeContext nodeCtx;
    private final LuceneQueryBuilder luceneQueryBuilder;
    private final NodeJobsCounter nodeJobsCounter;
    private final BigArrays bigArrays;
    private final Settings settings;
    private final CircuitBreakerService circuitBreakerService;

    ShardCollectorProviderFactory(ClusterService clusterService, CircuitBreakerService circuitBreakerService, Settings settings, Schemas schemas, ThreadPool threadPool, TransportActionProvider transportActionProvider, BlobIndicesService blobIndicesService, NodeContext nodeCtx, LuceneQueryBuilder luceneQueryBuilder, NodeJobsCounter nodeJobsCounter, BigArrays bigArrays) {
        this.settings = settings;
        this.circuitBreakerService = circuitBreakerService;
        this.schemas = schemas;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.transportActionProvider = transportActionProvider;
        this.blobIndicesService = blobIndicesService;
        this.nodeCtx = nodeCtx;
        this.luceneQueryBuilder = luceneQueryBuilder;
        this.nodeJobsCounter = nodeJobsCounter;
        this.bigArrays = bigArrays;
    }

    public ShardCollectorProvider create(IndexShard indexShard) {
        if (BlobIndex.isBlobIndex(indexShard.shardId().getIndexName())) {
            BlobShard blobShard = this.blobIndicesService.blobShardSafe(indexShard.shardId());
            return new BlobShardCollectorProvider(blobShard, this.clusterService, this.schemas, this.nodeJobsCounter, this.circuitBreakerService, this.nodeCtx, this.threadPool, this.settings, this.transportActionProvider);
        }
        return new LuceneShardCollectorProvider(this.schemas, this.luceneQueryBuilder, this.clusterService, this.nodeJobsCounter, this.circuitBreakerService, this.nodeCtx, this.threadPool, this.settings, this.transportActionProvider, indexShard, this.bigArrays);
    }
}

