/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import io.crate.analyze.OrderBy;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.breaker.RowAccountingWithEstimators;
import io.crate.concurrent.CompletableFutures;
import io.crate.data.BatchIterator;
import io.crate.data.CompositeBatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.exceptions.Exceptions;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.RemoteCollectorFactory;
import io.crate.execution.engine.collect.RowsTransformer;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.collect.collectors.OrderedLuceneBatchIteratorFactory;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.execution.engine.collect.sources.ShardCollectorProviderFactory;
import io.crate.execution.engine.collect.sources.SystemCollectSource;
import io.crate.execution.engine.pipeline.ProjectionToProjectorVisitor;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.execution.engine.sort.OrderingByPosition;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.support.ThreadPools;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexParts;
import io.crate.metadata.MapBackedRefResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.shard.unassigned.UnassignedShard;
import io.crate.metadata.sys.SysShardsTableInfo;
import io.crate.planner.consumer.OrderByPositionVisitor;
import io.crate.plugin.IndexEventListenerProxy;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class ShardCollectSource
implements CollectSource {
    private static final Logger LOGGER = LogManager.getLogger(ShardCollectSource.class);
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final RemoteCollectorFactory remoteCollectorFactory;
    private final Executor executor;
    private final ProjectorFactory sharedProjectorFactory;
    private final InputFactory inputFactory;
    private final Map<ShardId, Supplier<ShardCollectorProvider>> shards = new ConcurrentHashMap<ShardId, Supplier<ShardCollectorProvider>>();
    private final ShardCollectorProviderFactory shardCollectorProviderFactory;
    private final StaticTableReferenceResolver<UnassignedShard> unassignedShardReferenceResolver = new StaticTableReferenceResolver<UnassignedShard>(SysShardsTableInfo.unassignedShardsExpressions());
    private final StaticTableReferenceResolver<ShardRowContext> shardReferenceResolver = new StaticTableReferenceResolver<ShardRowContext>(SysShardsTableInfo.create().expressions());
    private final IntSupplier availableThreads;

    @Inject
    public ShardCollectSource(Settings settings, Schemas schemas, IndicesService indicesService, NodeContext nodeCtx, ClusterService clusterService, NodeJobsCounter nodeJobsCounter, LuceneQueryBuilder luceneQueryBuilder, ThreadPool threadPool, TransportActionProvider transportActionProvider, RemoteCollectorFactory remoteCollectorFactory, SystemCollectSource systemCollectSource, IndexEventListenerProxy indexEventListenerProxy, BlobIndicesService blobIndicesService, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.remoteCollectorFactory = remoteCollectorFactory;
        ThreadPoolExecutor executor = (ThreadPoolExecutor)threadPool.executor("search");
        this.availableThreads = ThreadPools.numIdleThreads(executor, EsExecutors.numberOfProcessors(settings));
        this.executor = executor;
        this.inputFactory = new InputFactory(nodeCtx);
        BigArrays bigArrays = new BigArrays(pageCacheRecycler, circuitBreakerService, "query", true);
        this.shardCollectorProviderFactory = new ShardCollectorProviderFactory(clusterService, circuitBreakerService, settings, schemas, threadPool, transportActionProvider, blobIndicesService, nodeCtx, luceneQueryBuilder, nodeJobsCounter, bigArrays);
        EvaluatingNormalizer nodeNormalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.DOC, new MapBackedRefResolver(Collections.emptyMap()), null);
        this.sharedProjectorFactory = new ProjectionToProjectorVisitor(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, transportActionProvider, this.inputFactory, nodeNormalizer, systemCollectSource::getRowUpdater, systemCollectSource::tableDefinition);
        indexEventListenerProxy.addLast(new LifecycleListener());
    }

    public ProjectorFactory getProjectorFactory(ShardId shardId) {
        ShardCollectorProvider collectorProvider = this.getCollectorProviderSafe(shardId);
        return collectorProvider.getProjectorFactory();
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase phase, CollectTask collectTask, boolean supportMoveToStart) {
        boolean requireMoveToStartSupport;
        RoutedCollectPhase collectPhase = (RoutedCollectPhase)phase;
        String localNodeId = this.clusterService.localNode().getId();
        Projectors projectors = new Projectors(collectPhase.projections(), collectPhase.jobId(), collectTask.txnCtx(), collectTask.getRamAccounting(), collectTask.memoryManager(), this.sharedProjectorFactory);
        boolean bl = requireMoveToStartSupport = supportMoveToStart && !projectors.providesIndependentScroll();
        if (collectPhase.maxRowGranularity() == RowGranularity.SHARD) {
            return CompletableFuture.completedFuture(projectors.wrap(InMemoryBatchIterator.of(this.getShardsIterator(collectTask.txnCtx(), collectPhase, localNodeId), SentinelRow.SENTINEL, true)));
        }
        OrderBy orderBy = collectPhase.orderBy();
        if (collectPhase.maxRowGranularity() == RowGranularity.DOC && orderBy != null) {
            return this.createMultiShardScoreDocCollector(collectPhase, requireMoveToStartSupport, collectTask, localNodeId).thenApply(projectors::wrap);
        }
        boolean hasShardProjections = Projections.hasAnyShardProjections(collectPhase.projections());
        Map<String, IntIndexedContainer> indexShards = collectPhase.routing().locations().get(localNodeId);
        List iterators = indexShards == null ? Collections.emptyList() : this.getIterators(collectTask, collectPhase, requireMoveToStartSupport, indexShards);
        return (switch (iterators.size()) {
            case 0 -> CompletableFuture.completedFuture(InMemoryBatchIterator.empty(SentinelRow.SENTINEL));
            case 1 -> (CompletableFuture)iterators.get(0);
            default -> hasShardProjections ? CompletableFutures.allAsList(iterators).thenApply(its -> CompositeBatchIterator.asyncComposite(this.executor, this.availableThreads, its.toArray(new BatchIterator[0]))) : CompletableFutures.allAsList(iterators).thenApply(its -> CompositeBatchIterator.seqComposite(its.toArray(new BatchIterator[0])));
        }).thenApply(it -> projectors.wrap((BatchIterator<Row>)it));
    }

    private CompletableFuture<BatchIterator<Row>> createMultiShardScoreDocCollector(RoutedCollectPhase collectPhase, boolean supportMoveToStart, CollectTask collectTask, String localNodeId) {
        Map<String, Map<String, IntIndexedContainer>> locations = collectPhase.routing().locations();
        SharedShardContexts sharedShardContexts = collectTask.sharedShardContexts();
        Map<String, IntIndexedContainer> indexShards = locations.get(localNodeId);
        ArrayList<CompletableFuture<OrderedDocCollector>> orderedDocCollectors = new ArrayList<CompletableFuture<OrderedDocCollector>>();
        Metadata metadata = this.clusterService.state().metadata();
        block3: for (Map.Entry<String, IntIndexedContainer> entry : indexShards.entrySet()) {
            String indexName = entry.getKey();
            Index index = metadata.index(indexName).getIndex();
            for (IntCursor shard : entry.getValue()) {
                ShardId shardId = new ShardId(index, shard.value);
                try {
                    SharedShardContext context = sharedShardContexts.getOrCreateContext(shardId);
                    ShardCollectorProvider shardCollectorProvider = this.getCollectorProviderSafe(shardId);
                    orderedDocCollectors.add(shardCollectorProvider.getFutureOrderedCollector(collectPhase, context, collectTask, supportMoveToStart));
                }
                catch (IllegalIndexShardStateException | ShardNotFoundException e) {
                    throw e;
                }
                catch (IndexNotFoundException e) {
                    if (IndexParts.isPartitioned(indexName)) continue block3;
                    throw e;
                }
            }
        }
        List<DataType<?>> columnTypes = Symbols.typeView(collectPhase.toCollect());
        OrderBy orderBy = collectPhase.orderBy();
        assert (orderBy != null) : "orderBy must not be null";
        return CompletableFutures.allAsList(orderedDocCollectors).thenApply(collectors -> OrderedLuceneBatchIteratorFactory.newInstance(collectors, OrderingByPosition.rowOrdering(OrderByPositionVisitor.orderByPositions(orderBy.orderBySymbols(), collectPhase.toCollect()), orderBy.reverseFlags(), orderBy.nullsFirst()), new RowAccountingWithEstimators(columnTypes, collectTask.getRamAccounting()), this.executor, this.availableThreads, supportMoveToStart));
    }

    private ShardCollectorProvider getCollectorProviderSafe(ShardId shardId) {
        Supplier<ShardCollectorProvider> supplier = this.shards.get(shardId);
        if (supplier == null) {
            throw new ShardNotFoundException(shardId);
        }
        ShardCollectorProvider shardCollectorProvider = supplier.get();
        if (shardCollectorProvider == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shardCollectorProvider;
    }

    private List<CompletableFuture<BatchIterator<Row>>> getIterators(CollectTask collectTask, RoutedCollectPhase collectPhase, boolean requiresScroll, Map<String, IntIndexedContainer> indexShards) {
        Metadata metadata = this.clusterService.state().metadata();
        ArrayList<CompletableFuture<BatchIterator<Row>>> iterators = new ArrayList<CompletableFuture<BatchIterator<Row>>>();
        for (Map.Entry<String, IntIndexedContainer> entry : indexShards.entrySet()) {
            String indexName = entry.getKey();
            IndexMetadata indexMD = metadata.index(indexName);
            if (indexMD == null) {
                if (IndexParts.isPartitioned(indexName)) continue;
                throw new IndexNotFoundException(indexName);
            }
            Index index = indexMD.getIndex();
            try {
                this.indicesService.indexServiceSafe(index);
            }
            catch (IndexNotFoundException e) {
                if (IndexParts.isPartitioned(indexName)) continue;
                throw e;
            }
            for (IntCursor shardCursor : entry.getValue()) {
                ShardId shardId = new ShardId(index, shardCursor.value);
                try {
                    ShardCollectorProvider shardCollectorProvider = this.getCollectorProviderSafe(shardId);
                    CompletableFuture<BatchIterator<Row>> iterator = shardCollectorProvider.getFutureIterator(collectPhase, requiresScroll, collectTask);
                    iterators.add(iterator);
                }
                catch (IllegalIndexShardStateException | ShardNotFoundException e) {
                    if (Symbols.containsColumn(collectPhase.toCollect(), DocSysColumns.FETCHID)) {
                        throw e;
                    }
                    iterators.add(this.remoteCollectorFactory.createCollector(shardId, collectPhase, collectTask, this.shardCollectorProviderFactory));
                }
                catch (IndexNotFoundException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Exceptions.rethrowRuntimeException(t);
                }
            }
        }
        return iterators;
    }

    private Iterable<Row> getShardsIterator(TransactionContext txnCtx, RoutedCollectPhase collectPhase, String localNodeId) {
        Iterable rows;
        Map<String, Map<String, IntIndexedContainer>> locations = collectPhase.routing().locations();
        ArrayList<UnassignedShard> unassignedShards = new ArrayList<UnassignedShard>();
        ArrayList<ShardRowContext> shardRowContexts = new ArrayList<ShardRowContext>();
        Map<String, IntIndexedContainer> indexShardsMap = locations.get(localNodeId);
        Metadata metadata = this.clusterService.state().metadata();
        for (Map.Entry<String, IntIndexedContainer> indexShards : indexShardsMap.entrySet()) {
            String indexName = indexShards.getKey();
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) continue;
            Index index = indexMetadata.getIndex();
            IntIndexedContainer shards = indexShards.getValue();
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                for (IntCursor shard : shards) {
                    unassignedShards.add(this.toUnassignedShard(index.getName(), UnassignedShard.markAssigned(shard.value)));
                }
                continue;
            }
            for (IntCursor shard : shards) {
                if (UnassignedShard.isUnassigned(shard.value)) {
                    unassignedShards.add(this.toUnassignedShard(index.getName(), UnassignedShard.markAssigned(shard.value)));
                    continue;
                }
                ShardId shardId = new ShardId(index, shard.value);
                try {
                    ShardCollectorProvider shardCollectorProvider = this.getCollectorProviderSafe(shardId);
                    shardRowContexts.add(shardCollectorProvider.shardRowContext());
                }
                catch (IllegalIndexShardStateException | ShardNotFoundException e) {
                    unassignedShards.add(this.toUnassignedShard(index.getName(), shard.value));
                }
            }
        }
        Iterable assignedShardRows = RowsTransformer.toRowsIterable(txnCtx, this.inputFactory, this.shardReferenceResolver, collectPhase, shardRowContexts, false);
        if (unassignedShards.size() > 0) {
            Iterable<Row> unassignedShardRows = RowsTransformer.toRowsIterable(txnCtx, this.inputFactory, this.unassignedShardReferenceResolver, collectPhase, unassignedShards, false);
            rows = Iterables.concat(assignedShardRows, unassignedShardRows);
        } else {
            rows = assignedShardRows;
        }
        if (collectPhase.orderBy() != null) {
            return RowsTransformer.sortRows(Iterables.transform(rows, Row::materialize), collectPhase);
        }
        return rows;
    }

    private UnassignedShard toUnassignedShard(String indexName, int shardId) {
        return new UnassignedShard(shardId, indexName, this.clusterService, false, ShardRoutingState.UNASSIGNED);
    }

    private class LifecycleListener
    implements IndexEventListener {
        private LifecycleListener() {
        }

        @Override
        public void afterIndexShardCreated(IndexShard indexShard) {
            LOGGER.debug("creating shard in {} {} {}", (Object)ShardCollectSource.this, (Object)indexShard.shardId(), (Object)ShardCollectSource.this.shards.size());
            assert (!ShardCollectSource.this.shards.containsKey(indexShard.shardId())) : "shard entry already exists upon add";
            if (indexShard.mapperService() == null) {
                LOGGER.warn("Index {} appears to be closed, skipping collector provider creation", (Object)indexShard.shardId().getIndexName());
            } else {
                com.google.common.base.Supplier providerSupplier = Suppliers.memoize(() -> ShardCollectSource.this.shardCollectorProviderFactory.create(indexShard));
                ShardCollectSource.this.shards.put(indexShard.shardId(), (Supplier<ShardCollectorProvider>)providerSupplier);
            }
        }

        @Override
        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            LOGGER.debug("removing shard upon close in {} shard={} numShards={}", (Object)ShardCollectSource.this, (Object)shardId, (Object)ShardCollectSource.this.shards.size());
            ShardCollectSource.this.shards.remove(shardId);
        }

        @Override
        public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
            if (ShardCollectSource.this.shards.remove(shardId) != null) {
                LOGGER.debug("removed shard upon delete in {} shard={} remainingShards={}", (Object)ShardCollectSource.this, (Object)shardId, (Object)ShardCollectSource.this.shards.size());
            } else {
                LOGGER.debug("shard not found upon delete in {} shard={} remainingShards={}", (Object)ShardCollectSource.this, (Object)shardId, (Object)ShardCollectSource.this.shards.size());
            }
        }
    }
}

