/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.execution.engine.collect.files.SqlFeatureContext;
import io.crate.execution.engine.collect.files.SqlFeatures;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.PartitionInfos;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.RoutineInfo;
import io.crate.metadata.RoutineInfos;
import io.crate.metadata.Schemas;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.pgcatalog.PgClassTable;
import io.crate.metadata.pgcatalog.PgIndexTable;
import io.crate.metadata.pgcatalog.PgProcTable;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.types.DataTypes;
import io.crate.types.Regproc;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;

public class InformationSchemaIterables
implements ClusterStateListener {
    public static final String PK_SUFFIX = "_pk";
    private static final Set<String> IGNORED_SCHEMAS = Set.of("information_schema", "sys", "blob", "pg_catalog");
    private final Schemas schemas;
    private final Iterable<RelationInfo> relations;
    private final Iterable<ViewInfo> views;
    private final PartitionInfos partitionInfos;
    private final Iterable<ColumnContext> columns;
    private final Iterable<RelationInfo> primaryKeys;
    private final Iterable<ConstraintInfo> constraints;
    private final Iterable<Void> referentialConstraints;
    private final Iterable<PgIndexTable.Entry> pgIndices;
    private final Iterable<PgClassTable.Entry> pgClasses;
    private final Iterable<PgProcTable.Entry> pgBuiltInFunc;
    private final Iterable<PgProcTable.Entry> pgTypeReceiveFunctions;
    private final NodeContext nodeCtx;
    private final FulltextAnalyzerResolver fulltextAnalyzerResolver;
    private Iterable<RoutineInfo> routines;
    private boolean initialClusterStateReceived = false;

    @Inject
    public InformationSchemaIterables(Schemas schemas, NodeContext nodeCtx, FulltextAnalyzerResolver fulltextAnalyzerResolver, ClusterService clusterService) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
        this.fulltextAnalyzerResolver = fulltextAnalyzerResolver;
        this.views = () -> InformationSchemaIterables.viewsStream(schemas).iterator();
        this.relations = () -> Stream.concat(InformationSchemaIterables.tablesStream(schemas), InformationSchemaIterables.viewsStream(schemas)).iterator();
        this.primaryKeys = () -> InformationSchemaIterables.sequentialStream(this.relations).filter(this::isPrimaryKey).iterator();
        this.columns = () -> InformationSchemaIterables.sequentialStream(this.relations).flatMap(r -> InformationSchemaIterables.sequentialStream(new ColumnsIterable((RelationInfo)r))).iterator();
        Iterable primaryKeyConstraints = () -> InformationSchemaIterables.sequentialStream(this.primaryKeys).map(t -> new ConstraintInfo((RelationInfo)t, t.ident().name() + PK_SUFFIX, ConstraintInfo.Type.PRIMARY_KEY)).iterator();
        Iterable notnullConstraints = () -> InformationSchemaIterables.sequentialStream(this.relations).flatMap(r -> InformationSchemaIterables.sequentialStream(new NotNullConstraintIterable((RelationInfo)r))).iterator();
        Iterable checkConstraints = () -> InformationSchemaIterables.sequentialStream(this.relations).flatMap(r -> r.checkConstraints().stream().map(chk -> new ConstraintInfo((RelationInfo)r, chk.name(), ConstraintInfo.Type.CHECK))).iterator();
        this.constraints = () -> Stream.of(InformationSchemaIterables.sequentialStream(primaryKeyConstraints), InformationSchemaIterables.sequentialStream(notnullConstraints), InformationSchemaIterables.sequentialStream(checkConstraints)).flatMap(Function.identity()).iterator();
        this.partitionInfos = new PartitionInfos(clusterService);
        this.referentialConstraints = Collections.emptyList();
        this.routines = Collections.emptyList();
        clusterService.addListener(this);
        this.pgIndices = () -> InformationSchemaIterables.tablesStream(schemas).filter(this::isPrimaryKey).map(this::pgIndex).iterator();
        this.pgClasses = () -> Stream.concat(InformationSchemaIterables.sequentialStream(this.relations).map(this::relationToPgClassEntry), InformationSchemaIterables.sequentialStream(this.primaryKeys).map(this::primaryKeyToPgClassEntry)).iterator();
        this.pgBuiltInFunc = () -> InformationSchemaIterables.sequentialStream(nodeCtx.functions().functionResolvers().values()).flatMap(Collection::stream).map(this::pgProc).iterator();
        this.pgTypeReceiveFunctions = () -> Stream.concat(InformationSchemaIterables.sequentialStream(PGTypes.pgTypes()).filter(t -> t.typArray() != 0).map(x -> x.typReceive().asDummySignature()).map(PgProcTable.Entry::of), Stream.of(PgProcTable.Entry.of(Regproc.of("array_recv").asDummySignature()))).iterator();
    }

    private boolean isPrimaryKey(RelationInfo relationInfo) {
        return relationInfo.primaryKey().size() > 1 || relationInfo.primaryKey().size() == 1 && !relationInfo.primaryKey().get(0).name().equals("_id");
    }

    private PgClassTable.Entry relationToPgClassEntry(RelationInfo info) {
        return new PgClassTable.Entry(OidHash.relationOid(info), OidHash.schemaOid(info.ident().schema()), info.ident(), info.ident().name(), this.toEntryType(info.relationType()), info.columns().size(), info.primaryKey().size() > 0);
    }

    private PgClassTable.Entry primaryKeyToPgClassEntry(RelationInfo info) {
        return new PgClassTable.Entry(OidHash.primaryKeyOid(info), OidHash.schemaOid(info.ident().schema()), info.ident(), info.ident().name() + "_pkey", PgClassTable.Entry.Type.INDEX, info.columns().size(), info.primaryKey().size() > 0);
    }

    private PgClassTable.Entry.Type toEntryType(RelationInfo.RelationType type) {
        switch (type) {
            case BASE_TABLE: {
                return PgClassTable.Entry.Type.RELATION;
            }
            case VIEW: {
                return PgClassTable.Entry.Type.VIEW;
            }
        }
        return null;
    }

    private PgIndexTable.Entry pgIndex(TableInfo tableInfo) {
        List<ColumnIdent> primaryKey = tableInfo.primaryKey();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (ColumnIdent columnIdent : primaryKey) {
            Reference pkRef = tableInfo.getReference(columnIdent);
            assert (pkRef != null) : "`getReference(..)` must not return null for columns retrieved from `primaryKey()`";
            Integer position = pkRef.position();
            positions.add(position);
        }
        return new PgIndexTable.Entry(OidHash.relationOid(tableInfo), OidHash.primaryKeyOid(tableInfo), positions);
    }

    private PgProcTable.Entry pgProc(FunctionProvider resolver) {
        return PgProcTable.Entry.of(resolver.getSignature());
    }

    private static Stream<ViewInfo> viewsStream(Schemas schemas) {
        return InformationSchemaIterables.sequentialStream(schemas).flatMap(schema -> InformationSchemaIterables.sequentialStream(schema.getViews())).filter(i -> !IndexParts.isPartitioned(i.ident().indexNameOrAlias()));
    }

    private static Stream<TableInfo> tablesStream(Schemas schemas) {
        return InformationSchemaIterables.sequentialStream(schemas).flatMap(s -> InformationSchemaIterables.sequentialStream(s.getTables())).filter(i -> !IndexParts.isPartitioned(i.ident().indexNameOrAlias()) && !IndexParts.isDangling(i.ident().indexNameOrAlias()));
    }

    private static <T> Stream<T> sequentialStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public Iterable<SchemaInfo> schemas() {
        return this.schemas;
    }

    public Iterable<RelationInfo> relations() {
        return this.relations;
    }

    public Iterable<PgIndexTable.Entry> pgIndices() {
        return this.pgIndices;
    }

    public Iterable<ViewInfo> views() {
        return this.views;
    }

    public Iterable<PartitionInfo> partitions() {
        return this.partitionInfos;
    }

    public Iterable<ColumnContext> columns() {
        return this.columns;
    }

    public Iterable<ConstraintInfo> constraints() {
        return this.constraints;
    }

    public Iterable<RoutineInfo> routines() {
        return this.routines;
    }

    public Iterable<SqlFeatureContext> features() {
        try {
            return SqlFeatures.loadFeatures();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Iterable<PgClassTable.Entry> pgClasses() {
        return this.pgClasses;
    }

    public Iterable<PgProcTable.Entry> pgProc() {
        return () -> Stream.concat(Stream.concat(InformationSchemaIterables.sequentialStream(this.pgBuiltInFunc), InformationSchemaIterables.sequentialStream(this.nodeCtx.functions().udfFunctionResolvers().values()).flatMap(Collection::stream).map(this::pgProc)), InformationSchemaIterables.sequentialStream(this.pgTypeReceiveFunctions)).iterator();
    }

    public Iterable<KeyColumnUsage> keyColumnUsage() {
        return InformationSchemaIterables.sequentialStream(this.primaryKeys).filter(tableInfo -> !IGNORED_SCHEMAS.contains(tableInfo.ident().schema())).flatMap(tableInfo -> {
            List<ColumnIdent> pks = tableInfo.primaryKey();
            PrimitiveIterator.OfInt ids = IntStream.range(1, pks.size() + 1).iterator();
            RelationName ident = tableInfo.ident();
            return pks.stream().map(pk -> new KeyColumnUsage(ident, (ColumnIdent)pk, ids.next()));
        })::iterator;
    }

    public Iterable<Void> referentialConstraintsInfos() {
        return this.referentialConstraints;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.initialClusterStateReceived) {
            Set<String> changedCustomMetadataSet = event.changedCustomMetadataSet();
            if (!changedCustomMetadataSet.contains("user_defined_functions")) {
                return;
            }
            this.createMetadataBasedIterables(event.state().getMetadata());
        } else {
            this.initialClusterStateReceived = true;
            this.createMetadataBasedIterables(event.state().getMetadata());
        }
    }

    private void createMetadataBasedIterables(Metadata metadata) {
        RoutineInfos routineInfos = new RoutineInfos(this.fulltextAnalyzerResolver, (UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions"));
        this.routines = () -> InformationSchemaIterables.sequentialStream(routineInfos).filter(Objects::nonNull).iterator();
    }

    public static class KeyColumnUsage {
        private final RelationName relationName;
        private final ColumnIdent pkColumnIdent;
        private final int ordinal;

        KeyColumnUsage(RelationName relationName, ColumnIdent pkColumnIdent, int ordinal) {
            this.relationName = relationName;
            this.pkColumnIdent = pkColumnIdent;
            this.ordinal = ordinal;
        }

        public String getSchema() {
            return this.relationName.schema();
        }

        public String getPkColumnIdent() {
            return this.pkColumnIdent.name();
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getTableName() {
            return this.relationName.name();
        }

        public String getFQN() {
            return this.relationName.fqn();
        }
    }

    static class NotNullConstraintIterable
    implements Iterable<ConstraintInfo> {
        private final RelationInfo info;

        NotNullConstraintIterable(RelationInfo info) {
            this.info = info;
        }

        @Override
        public Iterator<ConstraintInfo> iterator() {
            return new NotNullConstraintIterator(this.info);
        }
    }

    static class ColumnsIterable
    implements Iterable<ColumnContext> {
        private final RelationInfo relationInfo;

        ColumnsIterable(RelationInfo relationInfo) {
            this.relationInfo = relationInfo;
        }

        @Override
        public Iterator<ColumnContext> iterator() {
            return new ColumnsIterator(this.relationInfo);
        }
    }

    static class ColumnsIterator
    implements Iterator<ColumnContext> {
        private final Iterator<Reference> columns;
        private final RelationInfo tableInfo;
        private int ordinal = 0;

        ColumnsIterator(RelationInfo tableInfo) {
            this.columns = StreamSupport.stream(tableInfo.spliterator(), false).filter(reference -> !reference.column().isSystemColumn() && reference.valueType() != DataTypes.NOT_SUPPORTED).iterator();
            this.tableInfo = tableInfo;
        }

        @Override
        public boolean hasNext() {
            return this.columns.hasNext();
        }

        @Override
        public ColumnContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Columns iterator exhausted");
            }
            ++this.ordinal;
            Reference ref = this.columns.next();
            Integer position = ref.position();
            if (position == null) {
                position = this.ordinal;
            } else if (position != this.ordinal) {
                position = this.ordinal;
            }
            return new ColumnContext(this.tableInfo, ref, position);
        }
    }

    static class NotNullConstraintIterator
    implements Iterator<ConstraintInfo> {
        private final RelationInfo relationInfo;
        private final Iterator<Reference> nullableColumns;

        NotNullConstraintIterator(RelationInfo relationInfo) {
            this.relationInfo = relationInfo;
            this.nullableColumns = StreamSupport.stream(relationInfo.spliterator(), false).filter(reference -> !reference.column().isSystemColumn() && reference.valueType() != DataTypes.NOT_SUPPORTED && !reference.isNullable()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.nullableColumns.hasNext();
        }

        @Override
        public ConstraintInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Not null constraint iterator exhausted");
            }
            String constraintName = new StringBuilder(60).append(this.relationInfo.ident().schema()).append("_").append(this.relationInfo.ident().name()).append("_").append(this.nullableColumns.next().column().name()).append("_not_null").toString();
            return new ConstraintInfo(this.relationInfo, constraintName, ConstraintInfo.Type.CHECK);
        }
    }
}

