/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.files.FileInputFactory;
import io.crate.execution.engine.collect.files.FileReadingIterator;
import io.crate.execution.engine.collect.files.LineCollectorExpression;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.file.FileLineReferenceResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class FileCollectSource
implements CollectSource {
    private final ClusterService clusterService;
    private final Map<String, FileInputFactory> fileInputFactoryMap;
    private final InputFactory inputFactory;
    private final NodeContext nodeCtx;

    @Inject
    public FileCollectSource(NodeContext nodeCtx, ClusterService clusterService, Map<String, FileInputFactory> fileInputFactoryMap) {
        this.fileInputFactoryMap = fileInputFactoryMap;
        this.nodeCtx = nodeCtx;
        this.inputFactory = new InputFactory(nodeCtx);
        this.clusterService = clusterService;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
        FileUriCollectPhase fileUriCollectPhase = (FileUriCollectPhase)collectPhase;
        InputFactory.Context<LineCollectorExpression> ctx = this.inputFactory.ctxForRefs(txnCtx, FileLineReferenceResolver::getImplementation);
        ctx.add(collectPhase.toCollect());
        List<String> fileUris = FileCollectSource.targetUriToStringList(txnCtx, this.nodeCtx, fileUriCollectPhase.targetUri());
        return CompletableFuture.completedFuture(FileReadingIterator.newInstance(fileUris, ctx.topLevelInputs(), ctx.expressions(), fileUriCollectPhase.compression(), this.fileInputFactoryMap, fileUriCollectPhase.sharedStorage(), fileUriCollectPhase.nodeIds().size(), FileCollectSource.getReaderNumber(fileUriCollectPhase.nodeIds(), this.clusterService.state().nodes().getLocalNodeId()), fileUriCollectPhase.parserProperties(), fileUriCollectPhase.inputFormat()));
    }

    private static int getReaderNumber(Collection<String> nodeIds, String localNodeId) {
        Object[] readers = nodeIds.toArray(new String[0]);
        Arrays.sort(readers);
        return Arrays.binarySearch(readers, localNodeId);
    }

    private static List<String> targetUriToStringList(TransactionContext txnCtx, NodeContext nodeCtx, Symbol targetUri) {
        Object value = SymbolEvaluator.evaluate(txnCtx, nodeCtx, targetUri, Row.EMPTY, SubQueryResults.EMPTY);
        if (DataTypes.isSameType(targetUri.valueType(), DataTypes.STRING)) {
            String uri = (String)value;
            return Collections.singletonList(uri);
        }
        if (DataTypes.isArray(targetUri.valueType()) && DataTypes.isSameType(ArrayType.unnest(targetUri.valueType()), DataTypes.STRING)) {
            return (List)value;
        }
        throw AnalyzedCopyFrom.raiseInvalidType(targetUri.valueType());
    }
}

