/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.google.common.collect.Iterables;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.phases.TableFunctionCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.execution.engine.collect.sources.FileCollectSource;
import io.crate.execution.engine.collect.sources.NodeStatsCollectSource;
import io.crate.execution.engine.collect.sources.ProjectorSetupCollectSource;
import io.crate.execution.engine.collect.sources.ShardCollectSource;
import io.crate.execution.engine.collect.sources.SystemCollectSource;
import io.crate.execution.engine.collect.sources.TableFunctionCollectSource;
import io.crate.execution.engine.pipeline.ProjectionToProjectorVisitor;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.information.InformationSchemaInfo;
import io.crate.metadata.pgcatalog.PgCatalogSchemaInfo;
import io.crate.metadata.sys.SysNodesTableInfo;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.metadata.table.TableInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class CollectSourceResolver {
    private final CollectSource emptyCollectSource;
    private final Map<String, CollectSource> systemTableSource = new HashMap<String, CollectSource>();
    private final ShardCollectSource shardCollectSource;
    private final CollectSource fileCollectSource;
    private final ClusterService clusterService;
    private final CollectPhaseVisitor visitor;
    private final ProjectorSetupCollectSource tableFunctionSource;

    @Inject
    public CollectSourceResolver(ClusterService clusterService, NodeJobsCounter nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, Settings settings, ThreadPool threadPool, TransportActionProvider transportActionProvider, InformationSchemaInfo informationSchemaInfo, SysSchemaInfo sysSchemaInfo, PgCatalogSchemaInfo pgCatalogSchemaInfo, ShardCollectSource shardCollectSource, FileCollectSource fileCollectSource, TableFunctionCollectSource tableFunctionCollectSource, SystemCollectSource systemCollectSource, NodeStatsCollectSource nodeStatsCollectSource) {
        this.clusterService = clusterService;
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(nodeCtx);
        ProjectionToProjectorVisitor projectorFactory = new ProjectionToProjectorVisitor(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, transportActionProvider, new InputFactory(nodeCtx), normalizer, systemCollectSource::getRowUpdater, systemCollectSource::tableDefinition);
        this.shardCollectSource = shardCollectSource;
        this.fileCollectSource = new ProjectorSetupCollectSource(fileCollectSource, projectorFactory);
        this.tableFunctionSource = new ProjectorSetupCollectSource(tableFunctionCollectSource, projectorFactory);
        this.emptyCollectSource = new ProjectorSetupCollectSource(new VoidCollectSource(), projectorFactory);
        ProjectorSetupCollectSource sysSource = new ProjectorSetupCollectSource(systemCollectSource, projectorFactory);
        for (TableInfo tableInfo : sysSchemaInfo.getTables()) {
            this.systemTableSource.put(tableInfo.ident().fqn(), sysSource);
        }
        this.systemTableSource.put(SysNodesTableInfo.IDENT.fqn(), new ProjectorSetupCollectSource(nodeStatsCollectSource, projectorFactory));
        for (TableInfo tableInfo : pgCatalogSchemaInfo.getTables()) {
            this.systemTableSource.put(tableInfo.ident().fqn(), sysSource);
        }
        for (TableInfo tableInfo : informationSchemaInfo.getTables()) {
            this.systemTableSource.put(tableInfo.ident().fqn(), sysSource);
        }
        this.visitor = new CollectPhaseVisitor();
    }

    public CollectSource getService(CollectPhase collectPhase) {
        return collectPhase.accept(this.visitor, null);
    }

    private static class VoidCollectSource
    implements CollectSource {
        private VoidCollectSource() {
        }

        @Override
        public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
            return CompletableFuture.completedFuture(InMemoryBatchIterator.empty(SentinelRow.SENTINEL));
        }
    }

    private class CollectPhaseVisitor
    extends ExecutionPhaseVisitor<Void, CollectSource> {
        private CollectPhaseVisitor() {
        }

        @Override
        public CollectSource visitFileUriCollectPhase(FileUriCollectPhase phase, Void context) {
            return CollectSourceResolver.this.fileCollectSource;
        }

        @Override
        public CollectSource visitTableFunctionCollect(TableFunctionCollectPhase phase, Void context) {
            return CollectSourceResolver.this.tableFunctionSource;
        }

        @Override
        public CollectSource visitRoutedCollectPhase(RoutedCollectPhase phase, Void context) {
            if (!phase.isRouted()) {
                return CollectSourceResolver.this.emptyCollectSource;
            }
            String localNodeId = CollectSourceResolver.this.clusterService.state().nodes().getLocalNodeId();
            Set<String> routingNodes = phase.routing().nodes();
            if (!routingNodes.contains(localNodeId)) {
                throw new IllegalStateException("unsupported routing");
            }
            if (phase.routing().containsShards(localNodeId)) {
                return CollectSourceResolver.this.shardCollectSource;
            }
            Map<String, Map<String, IntIndexedContainer>> locations = phase.routing().locations();
            Map<String, IntIndexedContainer> indexShards = locations.get(localNodeId);
            if (indexShards == null) {
                throw new IllegalStateException("Can't resolve CollectService for collectPhase: " + phase);
            }
            String indexName = (String)Iterables.getFirst(indexShards.keySet(), null);
            if (indexName == null) {
                throw new IllegalStateException("Can't resolve CollectService for collectPhase: " + phase);
            }
            if (phase.maxRowGranularity() == RowGranularity.DOC && IndexParts.isPartitioned(indexName)) {
                return CollectSourceResolver.this.emptyCollectSource;
            }
            assert (indexShards.size() == 1) : "routing without shards that operates on non user-tables may only contain 1 index/table";
            CollectSource collectSource = CollectSourceResolver.this.systemTableSource.get(indexName);
            if (collectSource == null) {
                throw new IllegalStateException("Can't resolve CollectService for collectPhase: " + phase);
            }
            return collectSource;
        }
    }
}

