/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.execution.engine.collect.files.FileInput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

class URLFileInput
implements FileInput {
    private final URI fileUri;

    public URLFileInput(URI fileUri) {
        this.fileUri = fileUri;
    }

    @Override
    public List<URI> listUris(URI fileUri, Predicate<URI> uriPredicate) throws IOException {
        return Collections.singletonList(this.fileUri);
    }

    @Override
    public InputStream getStream(URI uri) throws IOException {
        URL url = uri.toURL();
        return url.openStream();
    }

    @Override
    public boolean sharedStorageDefault() {
        return true;
    }
}

