/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.primitives.Ints;
import io.crate.execution.engine.collect.files.SummitsContext;
import io.crate.types.DataTypes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.locationtech.spatial4j.shape.Point;

public class SummitsIterable
implements Iterable<SummitsContext> {
    private static final Splitter TAB_SPLITTER = Splitter.on((String)"\t");
    private final Supplier<List<SummitsContext>> summitsSupplierCache = Suppliers.memoizeWithExpiration(this::fetchSummits, (long)4L, (TimeUnit)TimeUnit.MINUTES);

    private List<SummitsContext> fetchSummits() {
        ArrayList<SummitsContext> summits = new ArrayList<SummitsContext>();
        try (InputStream input = SummitsIterable.class.getResourceAsStream("/config/names.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                List parts = TAB_SPLITTER.splitToList((CharSequence)line);
                summits.add(new SummitsContext((String)parts.get(0), Ints.tryParse((String)((String)parts.get(1))), Ints.tryParse((String)((String)parts.get(2))), SummitsIterable.safeParseCoordinates((String)parts.get(3)), (String)parts.get(4), (String)parts.get(5), (String)parts.get(6), (String)parts.get(7), Ints.tryParse((String)((String)parts.get(8)))));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot populate the sys.summits table", e);
        }
        return summits;
    }

    @Nullable
    private static Point safeParseCoordinates(String value) {
        return value.isEmpty() ? null : DataTypes.GEO_POINT.implicitCast(value);
    }

    @Override
    public Iterator<SummitsContext> iterator() {
        return ((List)this.summitsSupplierCache.get()).iterator();
    }
}

