/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import io.crate.execution.engine.collect.files.FileInput;
import io.crate.external.S3ClientHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class S3FileInput
implements FileInput {
    private AmazonS3 client;
    private static final Logger LOGGER = LogManager.getLogger(S3FileInput.class);
    final S3ClientHelper clientBuilder;

    public S3FileInput() {
        this.clientBuilder = new S3ClientHelper();
    }

    public S3FileInput(S3ClientHelper clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public List<URI> listUris(URI uri, Predicate<URI> uriPredicate) throws IOException {
        String bucketName = uri.getHost();
        if (this.client == null) {
            this.client = this.clientBuilder.client(uri);
        }
        String prefix = uri.getPath().length() > 1 ? uri.getPath().substring(1) : "";
        ArrayList<URI> uris = new ArrayList<URI>();
        ObjectListing list = this.client.listObjects(bucketName, prefix);
        this.addKeyUris(uris, list, uri, uriPredicate);
        while (list.isTruncated()) {
            list = this.client.listNextBatchOfObjects(list);
            this.addKeyUris(uris, list, uri, uriPredicate);
        }
        return uris;
    }

    private void addKeyUris(List<URI> uris, ObjectListing list, URI uri, Predicate<URI> uriPredicate) {
        List summaries = list.getObjectSummaries();
        for (S3ObjectSummary summary : summaries) {
            URI keyUri;
            String key = summary.getKey();
            if (key.endsWith("/") || !uriPredicate.test(keyUri = uri.resolve("/" + key))) continue;
            uris.add(keyUri);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("{}", (Object)keyUri);
        }
    }

    @Override
    public InputStream getStream(URI uri) throws IOException {
        S3Object object;
        if (this.client == null) {
            this.client = this.clientBuilder.client(uri);
        }
        if ((object = this.client.getObject(uri.getHost(), uri.getPath().substring(1))) != null) {
            return object.getObjectContent();
        }
        throw new IOException("Failed to load S3 URI: " + uri.toString());
    }

    @Override
    public boolean sharedStorageDefault() {
        return true;
    }
}

