/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import com.google.common.collect.ImmutableList;
import io.crate.execution.engine.collect.files.FileInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class LocalFsFileInput
implements FileInput {
    @Override
    public List<URI> listUris(URI fileUri, final Predicate<URI> uriPredicate) throws IOException {
        assert (fileUri != null) : "fileUri must not be null";
        assert (uriPredicate != null) : "uriPredicate must not be null";
        Path path = Paths.get(fileUri);
        if (!Files.isDirectory(path, new LinkOption[0]) && (path = path.getParent()) == null) {
            return ImmutableList.of();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return ImmutableList.of();
        }
        final ArrayList<URI> uris = new ArrayList<URI>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                URI uri = file.toUri();
                if (uriPredicate.test(uri)) {
                    uris.add(uri);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return uris;
    }

    @Override
    public InputStream getStream(URI uri) throws IOException {
        File file = new File(uri);
        return new FileInputStream(file);
    }

    @Override
    public boolean sharedStorageDefault() {
        return false;
    }
}

