/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.analyze.CopyFromParserProperties;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.engine.collect.files.LineCollectorExpression;
import io.crate.execution.engine.collect.files.LineParser;
import io.crate.expression.reference.file.LineContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;

public final class LineProcessor {
    private final LineContext lineContext = new LineContext();
    private final LineParser lineParser;

    public LineProcessor(CopyFromParserProperties parserProperties) {
        this.lineParser = new LineParser(parserProperties);
    }

    public void startCollect(Iterable<LineCollectorExpression<?>> collectorExpressions) {
        for (LineCollectorExpression<?> collectorExpression : collectorExpressions) {
            collectorExpression.startCollect(this.lineContext);
        }
    }

    void startWithUri(URI currentUri) {
        this.lineContext.resetCurrentLineNumber();
        this.lineContext.currentUri(currentUri);
    }

    void readFirstLine(URI currentUri, FileUriCollectPhase.InputFormat inputFormat, BufferedReader currentReader) throws IOException {
        this.lineParser.readFirstLine(currentUri, inputFormat, currentReader);
    }

    public void process(String line) throws IOException {
        this.lineContext.incrementCurrentLineNumber();
        byte[] jsonByteArray = this.lineParser.getByteArray(line);
        this.lineContext.rawSource(jsonByteArray);
    }

    public void setFailure(String failure) {
        this.lineContext.setCurrentUriFailure(failure);
    }
}

