/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.analyze.CopyFromParserProperties;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.operation.collect.files.CSVLineParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class LineParser {
    private final CopyFromParserProperties parserProperties;
    private CSVLineParser csvLineParser;
    private InputType inputType;

    public LineParser(CopyFromParserProperties parserProperties) {
        this.parserProperties = parserProperties;
    }

    public void readFirstLine(URI currentUri, FileUriCollectPhase.InputFormat inputFormat, BufferedReader currentReader) throws IOException {
        if (this.isInputCsv(inputFormat, currentUri)) {
            this.csvLineParser = new CSVLineParser(this.parserProperties);
            this.csvLineParser.parseHeader(currentReader.readLine());
            this.inputType = InputType.CSV;
        } else {
            this.inputType = InputType.JSON;
        }
    }

    public byte[] getByteArray(String line) throws IOException {
        if (this.inputType == InputType.CSV) {
            return this.csvLineParser.parse(line);
        }
        return line.getBytes(StandardCharsets.UTF_8);
    }

    private boolean isInputCsv(FileUriCollectPhase.InputFormat inputFormat, URI currentUri) {
        return inputFormat == FileUriCollectPhase.InputFormat.CSV || currentUri.toString().endsWith(".csv");
    }

    private static enum InputType {
        CSV,
        JSON;

    }
}

