/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.count;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.concurrent.CompletableFutures;
import io.crate.exceptions.JobKilledException;
import io.crate.execution.engine.collect.count.CountOperation;
import io.crate.execution.support.ThreadPools;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class InternalCountOperation
implements CountOperation {
    private final LuceneQueryBuilder queryBuilder;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPoolExecutor executor;
    private final int numProcessors;
    private final Schemas schemas;

    @Inject
    public InternalCountOperation(Settings settings, Schemas schemas, LuceneQueryBuilder queryBuilder, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService) {
        this.schemas = schemas;
        this.queryBuilder = queryBuilder;
        this.clusterService = clusterService;
        this.executor = (ThreadPoolExecutor)threadPool.executor("search");
        this.indicesService = indicesService;
        this.numProcessors = EsExecutors.numberOfProcessors(settings);
    }

    @Override
    public CompletableFuture<Long> count(TransactionContext txnCtx, Map<String, IntIndexedContainer> indexShardMap, Symbol filter) {
        ArrayList<CompletableFuture<Supplier<Long>>> futureSuppliers = new ArrayList<CompletableFuture<Supplier<Long>>>();
        Metadata metadata = this.clusterService.state().getMetadata();
        for (Map.Entry<String, IntIndexedContainer> entry : indexShardMap.entrySet()) {
            String indexName = entry.getKey();
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) {
                if (IndexParts.isPartitioned(indexName)) continue;
                throw new IndexNotFoundException(indexName);
            }
            Index index = indexMetadata.getIndex();
            for (IntCursor shardCursor : entry.getValue()) {
                int shardValue = shardCursor.value;
                futureSuppliers.add(this.prepareGetCount(txnCtx, index, shardValue, filter));
            }
        }
        MergePartialCountFunction mergeFunction = new MergePartialCountFunction();
        return ((CompletableFuture)CompletableFutures.allAsList(futureSuppliers).thenCompose(suppliers -> ThreadPools.runWithAvailableThreads(this.executor, ThreadPools.numIdleThreads(this.executor, this.numProcessors), suppliers))).thenApply((Function)mergeFunction);
    }

    public CompletableFuture<Supplier<Long>> prepareGetCount(TransactionContext txnCtx, Index index, int shardId, Symbol filter) {
        IndexService indexService;
        try {
            indexService = this.indicesService.indexServiceSafe(index);
        }
        catch (IndexNotFoundException e) {
            if (IndexParts.isPartitioned(index.getName())) {
                return CompletableFuture.completedFuture(() -> 0L);
            }
            return CompletableFuture.failedFuture(e);
        }
        IndexShard indexShard = indexService.getShard(shardId);
        CompletableFuture<Supplier<Long>> futureCount = new CompletableFuture<Supplier<Long>>();
        indexShard.awaitShardSearchActive(b -> {
            try {
                futureCount.complete(() -> this.syncCount(indexService, indexShard, txnCtx, filter));
            }
            catch (Throwable t) {
                futureCount.completeExceptionally(t);
            }
        });
        return futureCount;
    }

    private long syncCount(IndexService indexService, IndexShard indexShard, TransactionContext txnCtx, Symbol filter) {
        Engine.Searcher searcher = indexShard.acquireSearcher("count-operation");
        try {
            String indexName = indexShard.shardId().getIndexName();
            RelationName relationName = RelationName.fromIndexName(indexName);
            DocTableInfo table = (DocTableInfo)this.schemas.getTableInfo(relationName, Operation.READ);
            LuceneQueryBuilder.Context queryCtx = this.queryBuilder.convert(filter, txnCtx, indexService.mapperService(), indexName, indexService.newQueryShardContext(), table, indexService.cache());
            if (Thread.interrupted()) {
                throw JobKilledException.of("thread interrupted during count-operation");
            }
            long l = searcher.count(queryCtx.query());
            if (searcher != null) {
                searcher.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class MergePartialCountFunction
    implements Function<List<Long>, Long> {
        private MergePartialCountFunction() {
        }

        @Override
        public Long apply(List<Long> partialResults) {
            long result = 0L;
            for (Long partialResult : partialResults) {
                result += partialResult.longValue();
            }
            return result;
        }
    }
}

