/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.breaker.RamAccounting;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.distribution.merge.PassThroughPagingIterator;
import io.crate.execution.jobs.CumulativePageBucketReceiver;
import io.crate.execution.jobs.DistResultRXTask;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsRequest;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.JobResponse;
import io.crate.execution.jobs.transport.TransportJobAction;
import io.crate.metadata.settings.SessionSettings;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;

public class RemoteCollector {
    private static final Logger LOGGER = LogManager.getLogger(RemoteCollector.class);
    private static final int RECEIVER_PHASE_ID = 1;
    private final UUID jobId;
    private final SessionSettings sessionSettings;
    private final String localNode;
    private final String remoteNode;
    private final Executor executor;
    private final TransportJobAction transportJobAction;
    private final TransportKillJobsNodeAction transportKillJobsNodeAction;
    private final TasksService tasksService;
    private final RamAccounting ramAccounting;
    private final RowConsumer consumer;
    private final RoutedCollectPhase collectPhase;
    private final Object killLock = new Object();
    private final boolean scrollRequired;
    private final boolean enableProfiling;
    private RootTask context = null;
    private boolean collectorKilled = false;

    public RemoteCollector(UUID jobId, SessionSettings sessionSettings, String localNode, String remoteNode, TransportJobAction transportJobAction, TransportKillJobsNodeAction transportKillJobsNodeAction, Executor executor, TasksService tasksService, RamAccounting ramAccounting, RowConsumer consumer, RoutedCollectPhase collectPhase) {
        this.jobId = jobId;
        this.sessionSettings = sessionSettings;
        this.localNode = localNode;
        this.remoteNode = remoteNode;
        this.executor = executor;
        this.enableProfiling = false;
        this.scrollRequired = consumer.requiresScroll();
        this.transportJobAction = transportJobAction;
        this.transportKillJobsNodeAction = transportKillJobsNodeAction;
        this.tasksService = tasksService;
        this.ramAccounting = ramAccounting;
        this.consumer = consumer;
        this.collectPhase = collectPhase;
    }

    public void doCollect() {
        if (!this.createLocalContext()) {
            return;
        }
        this.createRemoteContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean createLocalContext() {
        RootTask.Builder builder = this.createPageDownstreamContext();
        try {
            Object object = this.killLock;
            synchronized (object) {
                if (this.collectorKilled) {
                    this.consumer.accept(null, new InterruptedException());
                    return false;
                }
                this.context = this.tasksService.createTask(builder);
                this.context.start();
                return true;
            }
        }
        catch (Throwable t) {
            if (this.context == null) {
                this.consumer.accept(null, t);
            } else {
                this.context.kill(t.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createRemoteContext() {
        NodeOperation nodeOperation = new NodeOperation(this.collectPhase, Collections.singletonList(this.localNode), 1, 0);
        Object object = this.killLock;
        synchronized (object) {
            if (this.collectorKilled) {
                this.context.kill(null);
                return;
            }
            this.transportJobAction.execute(this.remoteNode, new JobRequest(this.jobId, this.sessionSettings, this.localNode, Collections.singletonList(nodeOperation), this.enableProfiling), new ActionListener<JobResponse>(){

                @Override
                public void onResponse(JobResponse jobResponse) {
                    LOGGER.trace("RemoteCollector jobAction=onResponse");
                    if (RemoteCollector.this.collectorKilled) {
                        RemoteCollector.this.killRemoteContext();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    LOGGER.error("RemoteCollector jobAction=onFailure", (Throwable)e);
                    RemoteCollector.this.context.kill(e.getMessage());
                }
            });
        }
    }

    private RootTask.Builder createPageDownstreamContext() {
        RootTask.Builder builder = this.tasksService.newBuilder(this.jobId, this.sessionSettings.userName(), this.localNode, Collections.emptySet());
        PassThroughPagingIterator<Integer, Row> pagingIterator = this.scrollRequired ? PassThroughPagingIterator.repeatable() : PassThroughPagingIterator.oneShot();
        CumulativePageBucketReceiver pageBucketReceiver = new CumulativePageBucketReceiver(this.localNode, 1, this.executor, DataTypes.getStreamers(this.collectPhase.outputTypes()), this.consumer, pagingIterator, 1);
        builder.addTask(new DistResultRXTask(1, "RemoteCollectPhase", pageBucketReceiver, this.ramAccounting, 1));
        return builder;
    }

    private void killRemoteContext() {
        KillJobsRequest killRequest = new KillJobsRequest(List.of(this.jobId), this.sessionSettings.userName(), null);
        this.transportKillJobsNodeAction.broadcast(killRequest, (ActionListener)new ActionListener<Long>(){

            @Override
            public void onResponse(Long numKilled) {
                RemoteCollector.this.context.kill(null);
            }

            @Override
            public void onFailure(Exception e) {
                RemoteCollector.this.context.kill(e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(@Nullable Throwable throwable) {
        Object object = this.killLock;
        synchronized (object) {
            this.collectorKilled = true;
        }
    }
}

