/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.analyze.OrderBy;
import io.crate.expression.reference.doc.lucene.NullSentinelValues;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.FieldTypeLookup;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class OptimizeQueryForSearchAfter
implements Function<FieldDoc, Query> {
    private final OrderBy orderBy;
    private final Object[] missingValues;
    private final QueryShardContext queryShardContext;
    private final FieldTypeLookup fieldTypeLookup;

    public OptimizeQueryForSearchAfter(OrderBy orderBy, QueryShardContext queryShardContext, FieldTypeLookup fieldTypeLookup) {
        this.orderBy = orderBy;
        this.missingValues = new Object[orderBy.orderBySymbols().size()];
        this.queryShardContext = queryShardContext;
        this.fieldTypeLookup = fieldTypeLookup;
        for (int i = 0; i < orderBy.orderBySymbols().size(); ++i) {
            this.missingValues[i] = NullSentinelValues.nullSentinelForScoreDoc(orderBy, i);
        }
    }

    @Override
    public Query apply(FieldDoc lastCollected) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < this.orderBy.orderBySymbols().size(); ++i) {
            Query orderQuery;
            Symbol order = this.orderBy.orderBySymbols().get(i);
            Object value = lastCollected.fields[i];
            if (!(order instanceof Reference)) continue;
            ColumnIdent columnIdent = ((Reference)order).column();
            if (columnIdent.isSystemColumn()) {
                return null;
            }
            boolean nullsFirst = this.orderBy.nullsFirst()[i];
            Object object = value = value == null || value.equals(this.missingValues[i]) ? null : value;
            if (nullsFirst && value == null) continue;
            String columnName = columnIdent.fqn();
            MappedFieldType fieldType = Objects.requireNonNull(this.fieldTypeLookup.get(columnName), "Column must exist: " + columnName);
            if (nullsFirst) {
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                if (this.orderBy.reverseFlags()[i]) {
                    booleanQuery.add(fieldType.rangeQuery(null, value, false, true, null, null, this.queryShardContext), BooleanClause.Occur.MUST_NOT);
                } else {
                    booleanQuery.add(fieldType.rangeQuery(value, null, true, false, null, null, this.queryShardContext), BooleanClause.Occur.MUST_NOT);
                }
                orderQuery = booleanQuery.build();
            } else {
                orderQuery = this.orderBy.reverseFlags()[i] ? fieldType.rangeQuery(value, null, false, false, null, null, this.queryShardContext) : fieldType.rangeQuery(null, value, false, false, null, null, this.queryShardContext);
            }
            queryBuilder.add(orderQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery query = queryBuilder.build();
        if (query.clauses().size() > 0) {
            return query;
        }
        return null;
    }
}

