/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.common.unit.TimeValue;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.RowsTransformer;
import io.crate.execution.engine.collect.stats.NodeStatsRequest;
import io.crate.execution.engine.collect.stats.NodeStatsResponse;
import io.crate.execution.engine.collect.stats.TransportNodeStatsAction;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.expression.reference.sys.node.NodeStatsContext;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.metadata.sys.SysNodesTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public final class NodeStats {
    public static BatchIterator<Row> newInstance(TransportNodeStatsAction transportStatTablesAction, RoutedCollectPhase collectPhase, Collection<DiscoveryNode> nodes, TransactionContext txnCtx, InputFactory inputFactory) {
        return CollectingBatchIterator.newInstance(() -> {}, t -> {}, new LoadNodeStats(transportStatTablesAction, collectPhase, nodes, txnCtx, inputFactory), true);
    }

    private static boolean isTimeoutOrNodeNotReachable(Throwable t) {
        return t instanceof ReceiveTimeoutTransportException || t instanceof ConnectTransportException;
    }

    private static boolean dataAvailableInClusterState(Set<ColumnIdent> toCollect) {
        switch (toCollect.size()) {
            case 1: {
                return toCollect.contains(SysNodesTableInfo.Columns.ID) || toCollect.contains(SysNodesTableInfo.Columns.NAME);
            }
            case 2: {
                return toCollect.contains(SysNodesTableInfo.Columns.ID) && toCollect.contains(SysNodesTableInfo.Columns.NAME);
            }
        }
        return false;
    }

    private static Set<ColumnIdent> getRootColumns(Iterable<? extends Symbol> symbols) {
        HashSet<ColumnIdent> columns = new HashSet<ColumnIdent>();
        Consumer<Reference> addRootColumn = ref -> columns.add(ref.column().getRoot());
        for (Symbol symbol : symbols) {
            RefVisitor.visitRefs(symbol, addRootColumn);
        }
        return columns;
    }

    private static final class LoadNodeStats
    implements Supplier<CompletableFuture<? extends Iterable<? extends Row>>> {
        private static final TimeValue REQUEST_TIMEOUT = TimeValue.timeValueMillis(3000L);
        private final TransportNodeStatsAction nodeStatsAction;
        private final RoutedCollectPhase collectPhase;
        private final Collection<DiscoveryNode> nodes;
        private final TransactionContext txnCtx;
        private final InputFactory inputFactory;
        private final Map<ColumnIdent, RowCollectExpressionFactory<NodeStatsContext>> expressions;

        LoadNodeStats(TransportNodeStatsAction nodeStatsAction, RoutedCollectPhase collectPhase, Collection<DiscoveryNode> nodes, TransactionContext txnCtx, InputFactory inputFactory) {
            this.nodeStatsAction = nodeStatsAction;
            this.collectPhase = collectPhase;
            this.nodes = nodes;
            this.txnCtx = txnCtx;
            this.inputFactory = inputFactory;
            this.expressions = SysNodesTableInfo.create().expressions();
        }

        @Override
        public CompletableFuture<Iterable<Row>> get() {
            StaticTableReferenceResolver<NodeStatsContext> referenceResolver = new StaticTableReferenceResolver<NodeStatsContext>(this.expressions);
            return this.getNodeStatsContexts().thenApply(result -> RowsTransformer.toRowsIterable(this.txnCtx, this.inputFactory, referenceResolver, this.collectPhase, result));
        }

        private CompletableFuture<List<NodeStatsContext>> getNodeStatsContexts() {
            Set<ColumnIdent> toCollect = NodeStats.getRootColumns(this.collectPhase.toCollect());
            toCollect.addAll(NodeStats.getRootColumns(List.of(this.collectPhase.where())));
            return NodeStats.dataAvailableInClusterState(toCollect) ? this.getStatsFromLocalState() : this.getStatsFromRemote(toCollect);
        }

        private CompletableFuture<List<NodeStatsContext>> getStatsFromLocalState() {
            ArrayList<NodeStatsContext> rows = new ArrayList<NodeStatsContext>(this.nodes.size());
            for (DiscoveryNode node : this.nodes) {
                rows.add(new NodeStatsContext(node.getId(), node.getName()));
            }
            return CompletableFuture.completedFuture(rows);
        }

        private CompletableFuture<List<NodeStatsContext>> getStatsFromRemote(Set<ColumnIdent> toCollect) {
            final CompletableFuture<List<NodeStatsContext>> nodeStatsContextsFuture = new CompletableFuture<List<NodeStatsContext>>();
            final ArrayList rows = new ArrayList(this.nodes.size());
            final AtomicInteger remainingNodesToCollect = new AtomicInteger(this.nodes.size());
            for (final DiscoveryNode node : this.nodes) {
                final String nodeId = node.getId();
                NodeStatsRequest request = new NodeStatsRequest(toCollect);
                this.nodeStatsAction.execute(nodeId, request, new ActionListener<NodeStatsResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(NodeStatsResponse response) {
                        List list = rows;
                        synchronized (list) {
                            rows.add(response.nodeStatsContext());
                        }
                        if (remainingNodesToCollect.decrementAndGet() == 0) {
                            nodeStatsContextsFuture.complete(rows);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        Throwable t = SQLExceptions.unwrap(e);
                        if (NodeStats.isTimeoutOrNodeNotReachable(t)) {
                            NodeStatsContext statsContext = new NodeStatsContext(nodeId, node.getName());
                            List list = rows;
                            synchronized (list) {
                                rows.add(statsContext);
                            }
                            if (remainingNodesToCollect.decrementAndGet() == 0) {
                                nodeStatsContextsFuture.complete(rows);
                            }
                        } else {
                            nodeStatsContextsFuture.completeExceptionally(t);
                        }
                    }
                }, REQUEST_TIMEOUT);
            }
            return nodeStatsContextsFuture;
        }
    }
}

